/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.NeighboringCellInfo;
import android.telephony.TelephonyManager;
import io.apisense.dart.call.CallDartSkel;
import io.apisense.dart.call.CallData;
import io.apisense.dart.call.CallEvent;
import io.apisense.dart.call.CallSeed;
import io.apisense.dart.lib.EventBus;
import io.apisense.dart.lib.EventFilter;
import io.apisense.dart.lib.Tokens;
import io.apisense.sting.lib.Sensor;
import io.apisense.sting.phone.R;
import io.apisense.sting.phone.call.Cell;
import io.apisense.sting.phone.call.PhoneCallReceiver;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class CallSting
extends CallDartSkel {
    public static final Sensor SENSOR_DESCRIPTION = new Sensor("Phone calls", "call", "Enables to collect data about your GSM network and trigger actions at the end of phone calls", R.drawable.aps_call, new String[]{"android.permission.READ_PHONE_STATE", "android.permission.ACCESS_COARSE_LOCATION"});
    private final Context context;
    private CallData lastCall = null;
    private TelephonyManager telephonyManager;

    protected CallSting(EventBus bus, Context context) {
        super(bus, EnumSet.allOf(CallSeed.class));
        this.context = context;
        this.telephonyManager = (TelephonyManager)context.getSystemService("phone");
    }

    @Override
    public List<Cell> neighbouringCells() {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        if (Build.VERSION.SDK_INT >= 18) {
            List allCellInfo = this.telephonyManager.getAllCellInfo();
            for (CellInfo cellInfo : allCellInfo) {
                if (cellInfo instanceof CellInfoGsm) {
                    cells.add(Cell.getCellInfo((CellInfoGsm)cellInfo));
                }
                if (cellInfo instanceof CellInfoWcdma) {
                    cells.add(Cell.getCellInfo((CellInfoWcdma)cellInfo));
                }
                if (!(cellInfo instanceof CellInfoLte)) continue;
                cells.add(Cell.getCellInfo((CellInfoLte)cellInfo));
            }
        } else {
            List neighbors = this.telephonyManager.getNeighboringCellInfo();
            for (NeighboringCellInfo neighbor : neighbors) {
                cells.add(Cell.getCellInfo(neighbor, this.telephonyManager.getNetworkType(), this.telephonyManager.getNetworkOperator()));
            }
        }
        return cells;
    }

    @Override
    public String carrier() {
        return this.telephonyManager.getNetworkOperatorName();
    }

    @Override
    public String contact() {
        return this.lastCall != null ? this.lastCall.contact : null;
    }

    @Override
    public Long duration() {
        return this.lastCall != null ? this.lastCall.duration : null;
    }

    @Override
    protected Tokens.TokensListener<Void> initCallEndedListener() {
        return new Tokens.TokensListener<Void>(){
            private BroadcastReceiver receiver;

            public void init() {
            }

            public String computeTopic(EventFilter<Void> eventFilter) {
                if (this.receiver == null) {
                    this.receiver = new PhoneCallReceiver(){

                        @Override
                        protected void onCallEnded(long duration, String caller) {
                            CallSting.this.publish(CallEvent.CALL_ENDED, new CallData(CallSting.this.seeds(), duration, caller, CallSting.this.carrier(), CallSting.this.neighbouringCells()));
                        }
                    };
                    IntentFilter filter = new IntentFilter("android.intent.action.PHONE_STATE");
                    CallSting.this.context.registerReceiver(this.receiver, filter);
                }
                return CallEvent.CALL_ENDED.toString();
            }

            public void discardFilter(EventFilter<Void> eventFilter) {
                if (this.receiver != null) {
                    CallSting.this.context.unregisterReceiver(this.receiver);
                    PhoneCallReceiver.removeListener(CallSting.this.context);
                    this.receiver = null;
                }
            }

            public void release() {
            }
        };
    }
}

