/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone;

import io.apisense.dart.cpu.CpuDartSkel;
import io.apisense.dart.cpu.CpuData;
import io.apisense.dart.cpu.CpuSeed;
import io.apisense.dart.lib.EventBus;
import io.apisense.sting.lib.Sensor;
import io.apisense.sting.phone.R;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.EnumSet;

public class CpuSting
extends CpuDartSkel {
    public static final Sensor SENSOR_DESCRIPTION = new Sensor("CPU info", "cpu", "Retrieve information about the CPU.", R.drawable.aps_cpu, new String[0]);
    private final CpuData cpuData = this.readCPUFiles();

    protected CpuSting(EventBus bus) {
        super(bus, EnumSet.allOf(CpuSeed.class));
    }

    private CpuData readCPUFiles() {
        CpuData cpuInfoData = CpuSting.readCPUInfoFile();
        CpuData cpuLoadAverageData = CpuSting.readCPULoadAverageFile();
        CpuData cpuUptimeData = this.readCPUUptimeFile();
        return new CpuData(0, cpuInfoData.processor, cpuInfoData.cpuCores, cpuInfoData.cpuImplementer, cpuInfoData.cpuArchitecture, cpuInfoData.cpuVariant, cpuInfoData.cpuPart, cpuInfoData.cpuRevision, cpuInfoData.hardware, cpuInfoData.revision, cpuInfoData.serial, cpuLoadAverageData.loadAverage1Min, cpuLoadAverageData.loadAverage5Min, cpuLoadAverageData.loadAverage15Min, cpuLoadAverageData.loadAverageActiveTasks, cpuLoadAverageData.loadAverageTotalTasks, cpuUptimeData.uptime, cpuUptimeData.idleTime);
    }

    @Override
    public String processor() {
        return this.cpuData.processor;
    }

    @Override
    public Integer cpuCores() {
        return this.cpuData.cpuCores;
    }

    @Override
    public String cpuImplementer() {
        return this.cpuData.cpuImplementer;
    }

    @Override
    public Integer cpuArchitecture() {
        return this.cpuData.cpuArchitecture;
    }

    @Override
    public String cpuVariant() {
        return this.cpuData.cpuVariant;
    }

    @Override
    public String cpuPart() {
        return this.cpuData.cpuPart;
    }

    @Override
    public Integer cpuRevision() {
        return this.cpuData.cpuRevision;
    }

    @Override
    public String hardware() {
        return this.cpuData.hardware;
    }

    @Override
    public String revision() {
        return this.cpuData.revision;
    }

    @Override
    public String serial() {
        return this.cpuData.serial;
    }

    @Override
    public Float loadAverage1Min() {
        return this.cpuData.loadAverage1Min;
    }

    @Override
    public Float loadAverage5Min() {
        return this.cpuData.loadAverage5Min;
    }

    @Override
    public Float loadAverage15Min() {
        return this.cpuData.loadAverage15Min;
    }

    @Override
    public Integer loadAverageActiveTasks() {
        return this.cpuData.loadAverageActiveTasks;
    }

    @Override
    public Integer loadAverageTotalTasks() {
        return this.cpuData.loadAverageTotalTasks;
    }

    @Override
    public Float uptime() {
        return this.cpuData.uptime;
    }

    @Override
    public Float idleTime() {
        return this.cpuData.idleTime;
    }

    private static CpuData readCPUInfoFile() {
        File file = new File("/proc/cpuinfo");
        String processor = null;
        int cpuCores = 0;
        String cpuImplementer = null;
        int cpuArchitecture = 0;
        String cpuVariant = null;
        String cpuPart = null;
        int cpuRevision = 0;
        String hardware = null;
        String revision = "";
        String serial = null;
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] keyValuePair = line.split(":");
                if (keyValuePair.length < 2) continue;
                String keyword = keyValuePair[0].trim();
                String value = keyValuePair[1].trim();
                if (keyword == null || keyword.isEmpty()) continue;
                switch (keyword) {
                    case "Processor": {
                        processor = value;
                        break;
                    }
                    case "processor": {
                        ++cpuCores;
                        break;
                    }
                    case "CPU implementer": {
                        cpuImplementer = value;
                        break;
                    }
                    case "CPU architecture": {
                        cpuArchitecture = Integer.parseInt(value);
                        break;
                    }
                    case "CPU variant": {
                        cpuVariant = value;
                        break;
                    }
                    case "CPU part": {
                        cpuPart = value;
                        break;
                    }
                    case "CPU revision": {
                        cpuRevision = Integer.parseInt(value);
                        break;
                    }
                    case "Hardware": {
                        hardware = value;
                        break;
                    }
                    case "Revision": {
                        revision = value;
                        break;
                    }
                    case "Serial": {
                        serial = value;
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            return new CpuData(0, null, 0, null, 0, null, null, 0, null, null, null, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), 0, 0, Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
        return new CpuData(0, processor, cpuCores, cpuImplementer, cpuArchitecture, cpuVariant, cpuPart, cpuRevision, hardware, revision, serial, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), 0, 0, Float.valueOf(0.0f), Float.valueOf(0.0f));
    }

    private static CpuData readCPULoadAverageFile() {
        File file = new File("/proc/loadavg");
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            line = line.trim();
            String[] lineSplit = line.split("[ ]+");
            float loadAverage1Min = Float.parseFloat(lineSplit[0]);
            float loadAverage5Min = Float.parseFloat(lineSplit[1]);
            float loadAverage15Min = Float.parseFloat(lineSplit[2]);
            int loadAverageActiveTasks = Integer.parseInt(lineSplit[3].split("/")[0]);
            int loadAverageTotalTasks = Integer.parseInt(lineSplit[3].split("/")[1]);
            return new CpuData(0, null, 0, null, 0, null, null, 0, null, null, null, Float.valueOf(loadAverage1Min), Float.valueOf(loadAverage5Min), Float.valueOf(loadAverage15Min), loadAverageActiveTasks, loadAverageTotalTasks, Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
        catch (IOException e) {
            return new CpuData(0, null, 0, null, 0, null, null, 0, null, null, null, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), 0, 0, Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
    }

    private CpuData readCPUUptimeFile() {
        File file = new File("/proc/uptime");
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            line = line.trim();
            String[] lineSplit = line.split("[ ]+");
            float uptime = Float.parseFloat(lineSplit[0]);
            float idleTime = Float.parseFloat(lineSplit[1]);
            return new CpuData(0, null, 0, null, 0, null, null, 0, null, null, null, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), 0, 0, Float.valueOf(uptime), Float.valueOf(idleTime));
        }
        catch (IOException e) {
            return new CpuData(0, null, 0, null, 0, null, null, 0, null, null, null, Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), 0, 0, Float.valueOf(0.0f), Float.valueOf(0.0f));
        }
    }
}

