/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone;

import android.content.Context;
import io.apisense.dart.lib.EventBus;
import io.apisense.dart.localstorage.LocalStorageDartSkel;
import io.apisense.dart.localstorage.LocalStorageSeed;
import io.apisense.sting.lib.Sensor;
import io.apisense.sting.phone.R;
import io.apisense.sting.phone.storage.LocalStore;
import io.apisense.sting.phone.storage.StorageOperations;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;

public class LocalStorageSting
extends LocalStorageDartSkel {
    public static final Sensor SENSOR_DESCRIPTION = new Sensor("Storage", "localStorage", "Store data locally to use them within the application", R.drawable.aps_storage, new String[0]);
    private final Context context;
    private LocalStore localStore;
    private final Lock lockStore;

    protected LocalStorageSting(EventBus bus, Context context) {
        super(bus, EnumSet.allOf(LocalStorageSeed.class));
        this.context = context;
        this.lockStore = new ReentrantLock();
    }

    private StorageOperations getStore() {
        if (this.localStore == null) {
            this.lockStore.lock();
            try {
                if (this.localStore == null) {
                    this.localStore = new LocalStore(this.context, this.getId());
                }
            }
            finally {
                this.lockStore.unlock();
            }
        }
        return this.localStore;
    }

    @Override
    public Long store(Map<String, Object> toSave) {
        return this.getStore().insert(new JSONObject(toSave));
    }

    @Override
    public String retrieve(Long identifier) {
        return this.getStore().retrieve(identifier).toString();
    }

    @Override
    public String entries() {
        return this.getStore().entries().toString();
    }

    @Override
    public void remove(Long identifier) {
        this.getStore().remove(identifier);
    }

    @Override
    public void drop() {
        this.getStore().drop();
    }
}

