/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone.call;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import io.apisense.sting.phone.call.NumberHasher;

public abstract class PhoneCallReceiver
extends BroadcastReceiver {
    private static final String TAG = "APSPhoneCallReceiver";
    static APSPhoneStateListener listener;

    public void onReceive(Context context, Intent intent) {
        if (listener == null) {
            listener = new APSPhoneStateListener(){

                @Override
                protected void onPhoneBackToIdle(long duration, String caller) {
                    Log.d((String)PhoneCallReceiver.TAG, (String)("Phone call with " + caller + " ended (duration: " + duration + " s)"));
                    PhoneCallReceiver.this.onCallEnded(duration, caller);
                }
            };
            TelephonyManager telephony = (TelephonyManager)context.getSystemService("phone");
            telephony.listen((PhoneStateListener)listener, 32);
        }
    }

    protected abstract void onCallEnded(long var1, String var3);

    public static void removeListener(Context context) {
        if (listener != null) {
            TelephonyManager telephony = (TelephonyManager)context.getSystemService("phone");
            telephony.listen((PhoneStateListener)listener, 0);
            listener = null;
        }
    }

    public static abstract class APSPhoneStateListener
    extends PhoneStateListener {
        private static final NumberHasher hasher = new NumberHasher();
        private long start;
        private boolean isIdle = true;
        private String savedNumber = "";

        private void replaceSavedNumber(String newNumber) {
            String hashedNumber = hasher.hash(newNumber.getBytes());
            Log.v((String)PhoneCallReceiver.TAG, (String)("Trying to set value: " + hashedNumber));
            if (!newNumber.isEmpty()) {
                this.savedNumber = hashedNumber;
            }
        }

        private void resetSavedNumber() {
            this.savedNumber = "";
        }

        public void onCallStateChanged(int state, String incomingNumber) {
            super.onCallStateChanged(state, incomingNumber);
            Log.d((String)PhoneCallReceiver.TAG, (String)("Got state: " + state));
            switch (state) {
                case 1: 
                case 2: {
                    Log.v((String)PhoneCallReceiver.TAG, (String)("Non idle action " + state));
                    this.start = System.currentTimeMillis();
                    this.isIdle = false;
                    this.replaceSavedNumber(incomingNumber);
                    break;
                }
                case 0: {
                    Log.v((String)PhoneCallReceiver.TAG, (String)("idle action " + state + " - Was idle? " + this.isIdle));
                    this.replaceSavedNumber(incomingNumber);
                    if (!this.isIdle) {
                        long duration = (System.currentTimeMillis() - this.start) / 1000L;
                        this.onPhoneBackToIdle(duration, this.savedNumber);
                        this.resetSavedNumber();
                    }
                    this.isIdle = true;
                    break;
                }
            }
        }

        protected abstract void onPhoneBackToIdle(long var1, String var3);
    }
}

