/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone.storage;

import android.content.Context;
import io.apisense.sting.phone.storage.LocalStoreDBHelper;
import io.apisense.sting.phone.storage.StorageEntry;
import io.apisense.sting.phone.storage.StorageOperations;
import java.sql.SQLException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalStore
implements StorageOperations {
    private static final String TAG = "LocalStore";
    private final LocalStoreDBHelper dbHelper;

    public LocalStore(Context context, String cropSlug) {
        this.dbHelper = new LocalStoreDBHelper(context, cropSlug);
    }

    @Override
    public long insert(JSONObject object) {
        try {
            String toStore = object.toString();
            StorageEntry data = new StorageEntry(toStore);
            this.dbHelper.getDao().create((Object)data);
            return data.id;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public JSONObject retrieve(long id) {
        try {
            String entry = ((StorageEntry)this.dbHelper.getDao().queryForId((Object)Long.valueOf((long)id))).entry;
            return new JSONObject(entry);
        }
        catch (SQLException | JSONException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public JSONArray entries() {
        try {
            JSONArray entries = new JSONArray();
            for (StorageEntry entry : this.dbHelper.getDao()) {
                entries.put((Object)new JSONObject(entry.entry));
            }
            return entries;
        }
        catch (SQLException | JSONException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void remove(long id) {
        try {
            this.dbHelper.getDao().deleteById((Object)id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void drop() {
        try {
            this.dbHelper.dropDatabase();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

