{
    "name": "localStorage",
    "type": "dart",
    "description": "Record some data locally and retrieve them through the application, using the 'LocalStore' class.",
    "methods": [
        {
            "name": "store",
            "description": "Save the given json in a local database.",
            "parameters": [
                {
                    "name": "toSave",
                    "type": "Map<String, Object>",
                    "description": "A Json object to save."
                }
            ],
            "type": "long"
        },
        {
            "name": "remove",
            "description": "Remove an object from the ID returned by the 'store' method.",
            "parameters": [
                {
                    "name": "identifier",
                    "type": "long",
                    "description": "ID of the entry to remove."
                }
            ],
            "type": "Void"
        },
        {
            "name": "retrieve",
            "description": "Retrieve an object from the ID returned by the 'store' method. This method returns the raw string representing a JSON Object, you may want to parse it with 'JSON.parse'",
            "parameters": [
                {
                    "name": "identifier",
                    "type": "long",
                    "description": "ID of the entry to retrieve."
                }
            ],
            "type": "String"
        },
        {
            "name": "entries",
            "description": "Retrieve every store object. This method returns the raw string representing a JSON Array, you may want to parse it with 'JSON.parse'",
            "type": "String"
        },
        {
            "name": "drop",
            "description": "Clear the store.",
            "type": "Void"
        }
    ]
}
