/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.system;

import io.apisense.dart.api.Data;
import io.apisense.dart.api.Seed;
import io.apisense.dart.api.Token;
import io.apisense.dart.lib.DartImpl;
import io.apisense.dart.lib.Event;
import io.apisense.dart.lib.EventBus;
import io.apisense.dart.lib.Tokens;
import io.apisense.dart.lib.events.EventListenerTriggered;
import io.apisense.dart.system.SystemDart;
import io.apisense.dart.system.SystemData;
import io.apisense.dart.system.SystemEvent;
import io.apisense.dart.system.SystemLock;
import io.apisense.dart.system.SystemScreen;
import io.apisense.dart.system.SystemSeed;
import io.apisense.sting.phone.system.Application;
import io.apisense.sting.phone.system.Service;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public abstract class SystemDartSkel
extends DartImpl<SystemData>
implements SystemDart {
    private final EventBus bus;
    private Tokens<Void> screenUnlocked;
    private Tokens<Void> screenStateChanged;
    private Tokens<Void> foregroundAppChanged;

    protected SystemDartSkel(EventBus bus, Set<? extends Seed> fields) {
        super(SystemDart.class, fields);
        this.bus = bus;
    }

    protected SystemDartSkel(EventBus bus) {
        super(SystemDart.class, EnumSet.allOf(SystemSeed.class));
        this.bus = bus;
    }

    @Override
    public String foreground() {
        return null;
    }

    @Override
    public List<Application> runningApplications() {
        return null;
    }

    @Override
    public List<Application> installedApplications() {
        return null;
    }

    @Override
    public List<Service> runningServices() {
        return null;
    }

    @Override
    public boolean isScreen(int mask) {
        if (!this.available(SystemSeed.SCREEN.value())) {
            return false;
        }
        if (SystemScreen.parse(this.screen()) == null) {
            return false;
        }
        return SystemScreen.parse(this.screen()).matches(mask);
    }

    @Override
    public String screen() {
        return null;
    }

    @Override
    public boolean isLock(int mask) {
        if (!this.available(SystemSeed.LOCK.value())) {
            return false;
        }
        if (SystemLock.parse(this.lock()) == null) {
            return false;
        }
        return SystemLock.parse(this.lock()).matches(mask);
    }

    @Override
    public String lock() {
        return null;
    }

    protected abstract Tokens.TokensListener<Void> initScreenUnlockedListener();

    @Override
    public Token onScreenUnlocked(Object callback) {
        return this.getScreenUnlocked().register(callback, null);
    }

    private Tokens<Void> getScreenUnlocked() {
        if (this.screenUnlocked == null) {
            this.screenUnlocked = new Tokens(this.bus, this.initScreenUnlockedListener());
        }
        return this.screenUnlocked;
    }

    protected abstract Tokens.TokensListener<Void> initScreenStateChangedListener();

    @Override
    public Token onScreenStateChanged(Object callback) {
        return this.getScreenStateChanged().register(callback, null);
    }

    private Tokens<Void> getScreenStateChanged() {
        if (this.screenStateChanged == null) {
            this.screenStateChanged = new Tokens(this.bus, this.initScreenStateChangedListener());
        }
        return this.screenStateChanged;
    }

    protected abstract Tokens.TokensListener<Void> initForegroundAppChangedListener();

    @Override
    public Token onForegroundAppChanged(Object callback) {
        return this.getForegroundAppChanged().register(callback, null);
    }

    private Tokens<Void> getForegroundAppChanged() {
        if (this.foregroundAppChanged == null) {
            this.foregroundAppChanged = new Tokens(this.bus, this.initForegroundAppChangedListener());
        }
        return this.foregroundAppChanged;
    }

    public SystemData map(int mask) {
        return new SystemData(mask, SystemSeed.FOREGROUND.matches(mask) ? this.foreground() : null, SystemSeed.RUNNINGAPPLICATIONS.matches(mask) ? this.runningApplications() : null, SystemSeed.INSTALLEDAPPLICATIONS.matches(mask) ? this.installedApplications() : null, SystemSeed.RUNNINGSERVICES.matches(mask) ? this.runningServices() : null, SystemSeed.SCREEN.matches(mask) ? this.screen() : null, SystemSeed.LOCK.matches(mask) ? this.lock() : null);
    }

    protected final void publish(SystemEvent event, SystemData dataClass) {
        this.bus.publish((Event)EventListenerTriggered.build((String)event.toString(), (Data)dataClass, null));
    }

    public void stop() {
        this.getScreenUnlocked().stop();
        this.getScreenStateChanged().stop();
        this.getForegroundAppChanged().stop();
    }
}

