/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.system;

import io.apisense.dart.lib.BitMask;
import java.util.EnumSet;

public enum SystemLock {
    LOCKED("LOCKED"),
    UNLOCKED("UNLOCKED"),
    NOT_SECURED("NOT_SECURED");

    private final int value = 1 << this.ordinal();
    private final String label;

    private SystemLock(String label) {
        this.label = label;
    }

    public int value() {
        return this.value;
    }

    public final boolean matches(int value) {
        return BitMask.matches((int)this.value, (int)value);
    }

    public final boolean equals(String label) {
        return this.label.equalsIgnoreCase(label);
    }

    public final String toString() {
        return this.label;
    }

    public static final SystemLock parse(String label) {
        for (SystemLock val : SystemLock.values()) {
            if (!val.equals(label)) continue;
            return val;
        }
        return null;
    }

    public static final EnumSet<SystemLock> parse(int ... codes) {
        EnumSet<SystemLock> res = EnumSet.noneOf(SystemLock.class);
        for (int code : codes) {
            for (SystemLock val : SystemLock.values()) {
                if (!val.matches(code)) continue;
                res.add(val);
            }
        }
        return res;
    }
}

