/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone;

import android.content.Context;
import com.google.gson.Gson;
import io.apisense.dart.lib.EventBus;
import io.apisense.dart.localstorage.LocalStorageDartSkel;
import io.apisense.dart.localstorage.LocalStorageSeed;
import io.apisense.sting.lib.Sensor;
import io.apisense.sting.phone.R;
import io.apisense.sting.phone.storage.LocalStore;
import io.apisense.sting.phone.storage.StorageOperations;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LocalStorageSting
extends LocalStorageDartSkel {
    public static final Sensor SENSOR_DESCRIPTION = new Sensor("Storage", "localStorage", "Store data locally to use them within the application", R.drawable.aps_storage, new String[0]);
    private final Context context;
    private LocalStore localStore;
    private final Lock lockStore;
    private final Gson gson;

    protected LocalStorageSting(EventBus bus, Context context) {
        super(bus, EnumSet.allOf(LocalStorageSeed.class));
        this.context = context;
        this.lockStore = new ReentrantLock();
        this.gson = new Gson();
    }

    private StorageOperations getStore() {
        if (this.localStore == null) {
            this.lockStore.lock();
            try {
                if (this.localStore == null) {
                    this.localStore = new LocalStore(this.context, this.getId());
                }
            }
            finally {
                this.lockStore.unlock();
            }
        }
        return this.localStore;
    }

    @Override
    public Long store(Map<String, Object> json) {
        return this.getStore().insert(this.gson.toJson(json));
    }

    @Override
    public Long store(String key, Map<String, Object> value) {
        return this.getStore().insert(key, this.gson.toJson(value));
    }

    @Override
    public String retrieve(Object identifier) {
        if (identifier instanceof String) {
            return this.getStore().retrieve((String)identifier);
        }
        if (identifier instanceof Double) {
            return this.getStore().retrieve(((Double)identifier).longValue());
        }
        return this.getStore().retrieve((Long)identifier);
    }

    @Override
    public String entries() {
        return this.getStore().entries();
    }

    @Override
    public void remove(Object identifier) {
        if (identifier instanceof String) {
            this.getStore().remove((String)identifier);
        } else if (identifier instanceof Double) {
            this.getStore().remove(((Double)identifier).longValue());
        } else {
            this.getStore().remove((Long)identifier);
        }
    }

    @Override
    public void drop() {
        this.getStore().drop();
    }
}

