/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone;

import io.apisense.sdk.core.sting.InjectedStingPackage;
import io.apisense.sdk.core.sting.StingComponent;
import io.apisense.sdk.core.sting.StingFactory;
import io.apisense.sting.lib.Sting;
import io.apisense.sting.phone.CallSting;
import io.apisense.sting.phone.CpuSting;
import io.apisense.sting.phone.DeviceSting;
import io.apisense.sting.phone.LocalStorageSting;
import io.apisense.sting.phone.MemorySting;
import io.apisense.sting.phone.SystemSting;
import java.util.Arrays;
import java.util.List;

public class PhoneStingModule
extends InjectedStingPackage {
    public List<Sting> getInstances(StingComponent component) {
        return Arrays.asList(this.initCall(component), this.initDevice(component), this.initLocalStorage(component), this.initCpu(component), this.initMemory(component), this.initSystem(component));
    }

    private Sting initCall(StingComponent component) {
        return new StingFactory("call"){

            protected Sting init(StingComponent component) {
                return new CallSting(component.bus(), component.context());
            }
        }.getInstance(component);
    }

    private Sting initDevice(StingComponent component) {
        return new StingFactory("device"){

            protected Sting init(StingComponent component) {
                return new DeviceSting(component.bus(), component.context());
            }
        }.getInstance(component);
    }

    private Sting initLocalStorage(StingComponent component) {
        return new StingFactory("localStorage"){

            protected Sting init(StingComponent component) {
                return new LocalStorageSting(component.bus(), component.context());
            }
        }.getInstance(component);
    }

    private Sting initCpu(StingComponent component) {
        return new StingFactory("cpu"){

            protected Sting init(StingComponent component) {
                return new CpuSting(component.bus());
            }
        }.getInstance(component);
    }

    private Sting initMemory(StingComponent component) {
        return new StingFactory("memory"){

            protected Sting init(StingComponent component) {
                return new MemorySting(component.bus());
            }
        }.getInstance(component);
    }

    private Sting initSystem(StingComponent component) {
        return new StingFactory("system"){

            protected Sting init(StingComponent component) {
                return new SystemSting(component.bus(), component.context());
            }
        }.getInstance(component);
    }
}

