/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.PowerManager;
import android.os.Process;
import android.util.Log;
import android.view.WindowManager;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.apisense.dart.lib.EventBus;
import io.apisense.dart.lib.EventFilter;
import io.apisense.dart.lib.Tokens;
import io.apisense.dart.system.SystemDartSkel;
import io.apisense.dart.system.SystemData;
import io.apisense.dart.system.SystemEvent;
import io.apisense.dart.system.SystemLock;
import io.apisense.dart.system.SystemScreen;
import io.apisense.dart.system.SystemSeed;
import io.apisense.sting.lib.Sensor;
import io.apisense.sting.phone.R;
import io.apisense.sting.phone.system.Application;
import io.apisense.sting.phone.system.ApplicationUsage;
import io.apisense.sting.phone.system.ApplicationUsageStats;
import io.apisense.sting.phone.system.ScreenStateReceiver;
import io.apisense.sting.phone.system.Service;
import io.apisense.sting.phone.system.TopActivityFinder;
import io.apisense.sting.phone.system.UsageStatsActivity;
import io.apisense.sting.phone.system.WindowChangeDetectingService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SystemSting
extends SystemDartSkel {
    private static final String TAG = "APS/system";
    public static final Sensor SENSOR_DESCRIPTION = new Sensor("System info", "system", "Gives info about the system state.", R.drawable.aps_system, new String[0]);
    private static final String AMAPI_URL = "https://amapi-netsense.herokuapp.com/details/";
    private final Context context;
    private final TopActivityFinder topActivityFinder;
    private final ActivityManager activityManager;
    private final PackageManager packageManager;
    private final OkHttpClient okHttp = new OkHttpClient();
    private final Map<String, String> cacheCategories = new HashMap<String, String>();

    protected SystemSting(EventBus bus, Context context) {
        super(bus, EnumSet.allOf(SystemSeed.class));
        this.context = context;
        this.topActivityFinder = new TopActivityFinder(context);
        this.activityManager = (ActivityManager)this.context.getSystemService("activity");
        this.packageManager = this.context.getPackageManager();
    }

    @Override
    public String foreground() {
        return this.topActivityFinder.findTopPackage();
    }

    @Override
    public List<Application> runningApplications() {
        List runningAppProcesses = this.activityManager.getRunningAppProcesses();
        ArrayList<Application> applications = new ArrayList<Application>();
        if (runningAppProcesses == null) {
            return applications;
        }
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : runningAppProcesses) {
            applications.add(new Application(runningAppProcessInfo.processName, runningAppProcessInfo.uid));
        }
        return applications;
    }

    @Override
    public List<Application> installedApplications() {
        List installedApplications = this.packageManager.getInstalledApplications(128);
        ArrayList<Application> applications = new ArrayList<Application>();
        for (ApplicationInfo applicationInfo : installedApplications) {
            applications.add(new Application(applicationInfo.processName, applicationInfo.uid));
        }
        return applications;
    }

    @Override
    public List<Service> runningServices() {
        List services = this.activityManager.getRunningServices(Integer.MAX_VALUE);
        ArrayList<Service> serviceList = new ArrayList<Service>(services.size());
        for (ActivityManager.RunningServiceInfo service : services) {
            serviceList.add(new Service(service.process, service.clientPackage, service.activeSince, service.foreground, service.started, service.uid));
        }
        return serviceList;
    }

    @Override
    public String lock() {
        KeyguardManager kgManager = (KeyguardManager)this.context.getSystemService("keyguard");
        return this.checkLocked(kgManager).toString();
    }

    @Override
    public List<String> permissions(String packageName) {
        return this.getRequestedPermissions(packageName);
    }

    @Override
    public String category(String packageName) {
        String category = this.cacheCategories.get(packageName);
        if (category != null) {
            Log.d((String)TAG, (String)"Categroy get from cache");
            return category;
        }
        Request request = new Request.Builder().url(AMAPI_URL + packageName).build();
        Log.d((String)TAG, (String)"Categroy get from network request");
        try {
            Response response = this.okHttp.newCall(request).execute();
            category = new JSONObject(response.body().string()).get("category").toString();
            this.cacheCategories.put(packageName, category);
            return category;
        }
        catch (IOException | JSONException e) {
            Log.w((String)TAG, (String)"AMAPI request error", (Throwable)e);
            return "";
        }
    }

    @Override
    public Integer uid(String packageName) {
        try {
            ApplicationInfo appInfo = this.packageManager.getApplicationInfo(packageName, 128);
            return appInfo.uid;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)("The uid for \"" + packageName + "\" was not found."));
            return null;
        }
    }

    @Override
    public Map<String, ApplicationUsageStats> applicationUsageStats(Long startTimestamp, Long endTimestamp) {
        if (Build.VERSION.SDK_INT >= 22) {
            if (!this.isAllowedToAccessUsageStats()) {
                Log.w((String)TAG, (String)"The application is not allowed to access the usage stats.");
                return null;
            }
            UsageStatsManager usageStatsManager = (UsageStatsManager)this.context.getSystemService("usagestats");
            List usageStats = usageStatsManager.queryUsageStats(4, startTimestamp.longValue(), endTimestamp.longValue());
            HashMap<String, ApplicationUsageStats> applicationUsageStats = new HashMap<String, ApplicationUsageStats>();
            for (UsageStats stats : usageStats) {
                ApplicationUsageStats sgStats = applicationUsageStats.get(stats.getPackageName());
                if (sgStats == null) {
                    sgStats = new ApplicationUsageStats();
                    applicationUsageStats.put(stats.getPackageName(), sgStats);
                }
                sgStats.add(new ApplicationUsage(stats.getFirstTimeStamp(), stats.getLastTimeStamp(), stats.getLastTimeUsed(), stats.getTotalTimeInForeground()));
            }
            return applicationUsageStats;
        }
        Log.w((String)TAG, (String)"The version of the SDK is too low (< 22).");
        return null;
    }

    @Override
    public Map<String, ApplicationUsageStats> applicationUsageStatsForPackage(Long startTimestamp, Long endTimestamp, String packageName) {
        HashMap<String, ApplicationUsageStats> applicationUsageStats = new HashMap<String, ApplicationUsageStats>();
        ApplicationUsageStats pplctnsgStts = this.applicationUsageStats(startTimestamp, endTimestamp).get(packageName);
        if (pplctnsgStts == null) {
            return null;
        }
        applicationUsageStats.put(packageName, pplctnsgStts);
        return applicationUsageStats;
    }

    @Override
    public List<String> packageNames(Integer uid) {
        String[] pckgNms = this.packageManager.getPackagesForUid(uid.intValue());
        if (pckgNms == null) {
            return null;
        }
        return Arrays.asList(pckgNms);
    }

    @Override
    public List<String> applicationNames(Integer uid) {
        return Collections.singletonList(this.packageManager.getNameForUid(uid.intValue()));
    }

    private boolean isAllowedToAccessUsageStats() {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        AppOpsManager appOps = (AppOpsManager)this.context.getSystemService("appops");
        int mode = appOps.checkOpNoThrow("android:get_usage_stats", Process.myUid(), this.context.getPackageName());
        return mode == 0;
    }

    private List<String> getRequestedPermissions(String processName) {
        try {
            PackageInfo packageInfo = this.packageManager.getPackageInfo(processName, 4096);
            return Arrays.asList(packageInfo.requestedPermissions);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Error on permission retrieval for process: " + processName), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    private SystemLock checkLocked(KeyguardManager manager) {
        if (Build.VERSION.SDK_INT >= 16) {
            if (!manager.isKeyguardSecure()) {
                return SystemLock.NOT_SECURED;
            }
            return manager.isKeyguardLocked() ? SystemLock.LOCKED : SystemLock.UNLOCKED;
        }
        return manager.inKeyguardRestrictedInputMode() ? SystemLock.LOCKED : SystemLock.UNLOCKED;
    }

    @Override
    public String screen() {
        WindowManager winMan = (WindowManager)this.context.getSystemService("window");
        return this.checkScreen(winMan).toString();
    }

    private SystemScreen checkScreen(WindowManager manager) {
        if (Build.VERSION.SDK_INT >= 20) {
            switch (manager.getDefaultDisplay().getState()) {
                case 1: {
                    return SystemScreen.OFF;
                }
                case 2: 
                case 3: 
                case 4: {
                    return SystemScreen.ON;
                }
            }
            return SystemScreen.UNKNOWN;
        }
        PowerManager powerManager = (PowerManager)this.context.getSystemService("power");
        return powerManager.isScreenOn() ? SystemScreen.ON : SystemScreen.OFF;
    }

    @Override
    protected Tokens.TokensListener<Void> initScreenUnlockedListener() {
        return new ScreenListener(){

            @Override
            protected ScreenStateReceiver getBroadcastReceiver() {
                return new ScreenStateReceiver(){

                    @Override
                    protected void onScreenUnlocked() {
                        this.sendData();
                    }

                    @Override
                    public void onScreenOn() {
                    }

                    @Override
                    public void onScreenOff() {
                    }
                };
            }

            @Override
            protected IntentFilter getIntentFilter() {
                return new IntentFilter("android.intent.action.USER_PRESENT");
            }

            @Override
            protected SystemEvent getEvent() {
                return SystemEvent.SCREEN_UNLOCKED;
            }
        };
    }

    @Override
    protected Tokens.TokensListener<Void> initScreenStateChangedListener() {
        return new ScreenListener(){

            @Override
            protected ScreenStateReceiver getBroadcastReceiver() {
                return new ScreenStateReceiver(){

                    @Override
                    protected void onScreenUnlocked() {
                    }

                    @Override
                    public void onScreenOn() {
                        this.sendData();
                    }

                    @Override
                    public void onScreenOff() {
                        this.sendData();
                    }
                };
            }

            @Override
            protected IntentFilter getIntentFilter() {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
                intentFilter.addAction("android.intent.action.SCREEN_ON");
                return intentFilter;
            }

            @Override
            protected SystemEvent getEvent() {
                return SystemEvent.SCREENSTATE_CHANGED;
            }
        };
    }

    public void start() {
        if (!this.isAllowedToAccessUsageStats()) {
            Intent intent = new Intent(this.context, UsageStatsActivity.class);
            intent.addFlags(0x10000000);
            this.context.startActivity(intent);
        }
    }

    @Override
    protected Tokens.TokensListener<Void> initForegroundAppChangedListener() {
        return new Tokens.TokensListener<Void>(){
            private WindowChangeDetectingService.OnTopWindowChanged callback;

            public void init() {
            }

            public String computeTopic(EventFilter<Void> eventFilter) {
                if (this.callback == null) {
                    this.callback = new WindowChangeDetectingService.OnTopWindowChanged(){

                        @Override
                        public void newTopApplication(String applicationName) {
                            SystemSting.this.publish(SystemEvent.FOREGROUNDAPP_CHANGED, (SystemData)SystemSting.this.data());
                        }
                    };
                    WindowChangeDetectingService.addCallback(this.callback);
                }
                return SystemEvent.FOREGROUNDAPP_CHANGED.toString();
            }

            public void discardFilter(EventFilter<Void> eventFilter) {
                if (this.callback != null) {
                    WindowChangeDetectingService.removeCallback(this.callback);
                }
            }

            public void release() {
            }
        };
    }

    private abstract class ScreenListener
    implements Tokens.TokensListener<Void> {
        private BroadcastReceiver receiver;

        private ScreenListener() {
        }

        public void init() {
        }

        public String computeTopic(EventFilter<Void> eventFilter) {
            if (this.receiver == null) {
                this.receiver = this.getBroadcastReceiver();
                SystemSting.this.context.registerReceiver(this.receiver, this.getIntentFilter());
            }
            return this.getEvent().toString();
        }

        public void discardFilter(EventFilter<Void> eventFilter) {
            if (this.receiver != null) {
                SystemSting.this.context.unregisterReceiver(this.receiver);
                this.receiver = null;
            }
        }

        public void release() {
        }

        protected void sendData() {
            SystemSting.this.publish(this.getEvent(), (SystemData)SystemSting.this.data());
        }

        protected abstract BroadcastReceiver getBroadcastReceiver();

        protected abstract IntentFilter getIntentFilter();

        protected abstract SystemEvent getEvent();
    }
}

