/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone.storage;

import android.content.Context;
import com.j256.ormlite.stmt.QueryBuilder;
import io.apisense.sting.phone.storage.LocalStoreDBHelper;
import io.apisense.sting.phone.storage.StorageEntry;
import io.apisense.sting.phone.storage.StorageOperations;
import java.sql.SQLException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalStore
implements StorageOperations {
    private static final String TAG = "LocalStore";
    private final LocalStoreDBHelper dbHelper;

    public LocalStore(Context context, String cropSlug) {
        this.dbHelper = new LocalStoreDBHelper(context, cropSlug);
    }

    @Override
    public long insert(String json) {
        return this.insert(null, json);
    }

    @Override
    public long insert(String key, String json) {
        try {
            StorageEntry entry = this.retrieveStorageEntry(key);
            if (entry != null) {
                entry.value = json;
                this.dbHelper.getDao().update((Object)entry);
                return entry.id;
            }
            StorageEntry data = new StorageEntry(key, json);
            this.dbHelper.getDao().create((Object)data);
            return data.id;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private StorageEntry retrieveStorageEntry(String key) {
        if (key == null) {
            return null;
        }
        try {
            QueryBuilder builder = this.dbHelper.getDao().queryBuilder();
            builder.where().eq("key", (Object)key);
            return (StorageEntry)builder.queryForFirst();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String retrieve(long id) {
        try {
            StorageEntry entry = (StorageEntry)this.dbHelper.getDao().queryForId((Object)id);
            return entry == null ? null : entry.value;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public String retrieve(String key) {
        StorageEntry entry = this.retrieveStorageEntry(key);
        return entry == null ? null : entry.value;
    }

    @Override
    public String entries() {
        try {
            JSONArray entries = new JSONArray();
            for (StorageEntry entry : this.dbHelper.getDao()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", entry.id);
                jsonObject.put("key", (Object)entry.key);
                jsonObject.put("value", (Object)entry.value);
                entries.put((Object)jsonObject);
            }
            return entries.toString();
        }
        catch (SQLException | JSONException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void remove(long id) {
        try {
            this.dbHelper.getDao().deleteById((Object)id);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void remove(String key) {
        try {
            QueryBuilder builder = this.dbHelper.getDao().queryBuilder();
            builder.where().eq("key", (Object)key);
            StorageEntry entry = (StorageEntry)builder.queryForFirst();
            this.dbHelper.getDao().delete((Object)entry);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void drop() {
        try {
            this.dbHelper.dropDatabase();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

