/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone.storage;

import android.content.Context;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.j256.ormlite.android.apptools.OrmLiteSqliteOpenHelper;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import io.apisense.sting.phone.storage.StorageEntry;

class LocalStoreDBHelper
extends OrmLiteSqliteOpenHelper {
    private static final String TAG = "LocalStoreDBHelper";
    private static final int DATABASE_VERSION = 2;
    private Dao<StorageEntry, Long> jsonDao;

    LocalStoreDBHelper(Context context, String cropSlug) {
        super(context, LocalStoreDBHelper.dbName(cropSlug), null, 2);
    }

    private static String dbName(String cropSlug) {
        return "local_" + cropSlug + ".sqlite";
    }

    public void dropDatabase() throws java.sql.SQLException {
        TableUtils.clearTable((ConnectionSource)this.connectionSource, StorageEntry.class);
    }

    public Dao<StorageEntry, Long> getDao() throws java.sql.SQLException {
        if (this.jsonDao == null) {
            this.jsonDao = this.getDao(StorageEntry.class);
        }
        return this.jsonDao;
    }

    public void onCreate(SQLiteDatabase database, ConnectionSource connectionSource) {
        try {
            TableUtils.createTable((ConnectionSource)connectionSource, StorageEntry.class);
        }
        catch (java.sql.SQLException e) {
            Log.e((String)TAG, (String)"Can't create database", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void onUpgrade(SQLiteDatabase database, ConnectionSource connectionSource, int oldVersion, int newVersion) {
        if (oldVersion < 2) {
            database.beginTransaction();
            try {
                database.execSQL("CREATE TEMPORARY TABLE `entry_backup` (`id`, `entry`)");
                database.execSQL("INSERT INTO `entry_backup` SELECT `id`, `entry` FROM `entry`");
                database.execSQL("DROP TABLE `entry`");
                database.execSQL("CREATE TABLE `entry` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `key` VARCHAR, `value` VARCHAR NOT NULL, UNIQUE (`key`))");
                database.execSQL("INSERT INTO `entry` (`id`, `value`) SELECT `id`, `entry` FROM `entry_backup`");
                database.execSQL("DROP TABLE `entry_backup`");
                database.setTransactionSuccessful();
            }
            catch (SQLException e) {
                Log.e((String)TAG, (String)"Can't update database", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                database.endTransaction();
            }
        }
    }
}

