{
    "name": "memory",
    "type": "dart",
    "description": "Memory Information.",
    "seeds": [
        {
            "name": "memtotal",
            "description": "Total amount of usable RAM, in kibibytes, which is physical RAM minus a number of reserved bits and the kernel binary code.",
            "type": "integer"
        },
        {
            "name": "memfree",
            "description": "The amount of physical RAM, in kibibytes, left unused by the system.",
            "type": "integer"
        },
        {
            "name": "buffers",
            "description": "The amount, in kibibytes, of temporary storage for raw disk blocks.",
            "type": "integer"
        },
        {
            "name": "cached",
            "description": "The amount of physical RAM, in kibibytes, used as cache memory.",
            "type": "integer"
        },
        {
            "name": "swapcached",
            "description": "The amount of memory, in kibibytes, that has once been moved into swap, then back into the main memory, but still also remains in the swapfile. This saves I/O, because the memory does not need to be moved into swap again.",
            "type": "integer"
        },
        {
            "name": "active",
            "description": "The amount of memory, in kibibytes, that has been used more recently and is usually not reclaimed unless absolutely necessary.",
            "type": "integer"
        },
        {
            "name": "inactive",
            "description": "The amount of memory, in kibibytes, that has been used less recently and is more eligible to be reclaimed for other purposes.",
            "type": "integer"
        },
        {
            "name": "activeanon",
            "description": "The amount of anonymous and tmpfs/shmem memory, in kibibytes, that is in active use, or was in active use since the last time the system moved something to swap.",
            "type": "integer"
        },
        {
            "name": "inactiveanon",
            "description": "The amount of anonymous and tmpfs/shmem memory, in kibibytes, that is a candidate for eviction.",
            "type": "integer"
        },
        {
            "name": "activefile",
            "description": "The amount of file cache memory, in kibibytes, that is in active use, or was in active use since the last time the system reclaimed memory.",
            "type": "integer"
        },
        {
            "name": "inactivefile",
            "description": "The amount of file cache memory, in kibibytes, that is newly loaded from the disk, or is a candidate for reclaiming.",
            "type": "integer"
        },
        {
            "name": "unevictable",
            "description": "The amount of memory, in kibibytes, discovered by the pageout code, that is not evictable because it is locked into memory by user programs.",
            "type": "integer"
        },
        {
            "name": "mlocked",
            "description": "The total amount of memory, in kibibytes, that is not evictable because it is locked into memory by user programs.",
            "type": "integer"
        },
        {
            "name": "hightotal",
            "description": "Total amount of highmem.",
            "type": "integer"
        },
        {
            "name": "highfree",
            "description": "Amount of free highmem.",
            "type": "integer"
        },
        {
            "name": "lowtotal",
            "description": "Total amount of lowmem.",
            "type": "integer"
        },
        {
            "name": "lowfree",
            "description": "Amount of free lowmem.",
            "type": "integer"
        },
        {
            "name": "swaptotal",
            "description": "The total amount of swap available, in kibibytes.",
            "type": "integer"
        },
        {
            "name": "swapfree",
            "description": "The total amount of swap free, in kibibytes.",
            "type": "integer"
        },
        {
            "name": "dirty",
            "description": "The total amount of memory, in kibibytes, waiting to be written back to the disk.",
            "type": "integer"
        },
        {
            "name": "writeback",
            "description": "The total amount of memory, in kibibytes, actively being written back to the disk.",
            "type": "integer"
        },
        {
            "name": "anonpages",
            "description": "The total amount of memory, in kibibytes, used by pages that are not backed by files and are mapped into userspace page tables.",
            "type": "integer"
        },
        {
            "name": "mapped",
            "description": "The memory, in kibibytes, used for files that have been mmaped, such as libraries.",
            "type": "integer"
        },
        {
            "name": "shmem",
            "description": "The total amount of memory, in kibibytes, used by shared memory (shmem) and tmpfs.",
            "type": "integer"
        },
        {
            "name": "slab",
            "description": "The total amount of memory, in kibibytes, used by the kernel to cache data structures for its own use.",
            "type": "integer"
        },
        {
            "name": "sreclaimable",
            "description": "The part of Slab that can be reclaimed, such as caches.",
            "type": "integer"
        },
        {
            "name": "sunreclaimable",
            "description": "The part of Slab that cannot be reclaimed even when lacking memory.",
            "type": "integer"
        },
        {
            "name": "kernelstack",
            "description": "The amount of memory, in kibibytes, used by the kernel stack allocations done for each task in the system.",
            "type": "integer"
        },
        {
            "name": "pagetables",
            "description": "The total amount of memory, in kibibytes, dedicated to the lowest page table level.",
            "type": "integer"
        },
        {
            "name": "nfsunstable",
            "description": "The amount, in kibibytes, of NFS pages sent to the server but not yet committed to the stable storage.",
            "type": "integer"
        },
        {
            "name": "bounce",
            "description": "The amount of memory, in kibibytes, used for the block device \"bounce buffers\".",
            "type": "integer"
        },
        {
            "name": "writebacktmp",
            "description": "The amount of memory, in kibibytes, used by FUSE for temporary writeback buffers.",
            "type": "integer"
        },
        {
            "name": "commitlimit",
            "description": "The total amount of memory currently available to be allocated on the system based on the overcommit ratio (vm.overcommit_ratio). This limit is only adhered to if strict overcommit accounting is enabled (mode 2 in vm.overcommit_memory).",
            "type": "integer"
        },
        {
            "name": "committedas",
            "description": "The total amount of memory, in kibibytes, estimated to complete the workload. This value represents the worst case scenario value, and also includes swap memory.",
            "type": "integer"
        },
        {
            "name": "vmalloctotal",
            "description": "The total amount of memory, in kibibytes, of total allocated virtual address space.",
            "type": "integer"
        },
        {
            "name": "vmallocused",
            "description": "The total amount of memory, in kibibytes, of used virtual address space.",
            "type": "integer"
        },
        {
            "name": "vmallocchunck",
            "description": "The largest contiguous block of memory, in kibibytes, of available virtual address space.",
            "type": "integer"
        }
    ]
}