{
    "name": "system",
    "type": "dart",
    "description": "Monitors device state.",
    "seeds": [
        {
            "name": "foreground",
            "description": "Name of the foreground application",
            "type": "string"
        },
        {
            "name": "runningApplications",
            "description": "Applications running on the device.",
            "type": "List<io.apisense.sting.phone.system.Application>"
        },
        {
            "name": "installedApplications",
            "description": "Applications installed on the device.",
            "type": "List<io.apisense.sting.phone.system.Application>"
        },
        {
            "name": "runningServices",
            "description": "Services running on the device.",
            "type": "List<io.apisense.sting.phone.system.Service>"
        },
        {
            "name": "screen",
            "description": "Current illumination state of the screen",
            "type": ["ON", "OFF", "UNKNOWN"]
        },
        {
            "name": "lock",
            "description": "Current locking state of the screen, NOT_SECURED means that no protection is set",
            "type": ["LOCKED", "UNLOCKED", "NOT_SECURED"]
        }
    ],
    "methods": [
        {
            "name": "permissions",
            "description": "Get the permissions for the given package.",
            "parameters": [
                {
                    "name": "packageName",
                    "description": "The application/service package name.",
                    "type": "String"
                }
            ],
            "type": "List<String>"
        },
        {
            "name": "category",
            "description": "Get the app store category for the given package.",
            "parameters": [
                {
                    "name": "packageName",
                    "description": "The application/service package name.",
                    "type": "String"
                }
            ],
            "type": "String"
        },
        {
            "name": "uid",
            "description": "Get the application/service uid. If the packageName does not found on the phone, null is returned.",
            "parameters": [
                {
                    "name": "packageName",
                    "description": "The application/service package name.",
                    "type": "String"
                }
            ],
            "type": "Integer"
        },
        {
            "name": "applicationUsageStats",
            "description": "Get all application usage stats for the given period. The method return null if the user did not allow the application to access the usage stats or if the version of the SDK is not compatible (min. 22).",
            "parameters": [
                {
                    "name": "startTimestamp",
                    "description": "The start timestamp of the period.",
                    "type": "long"
                },
                {
                    "name": "endTimestamp",
                    "description": "The end timestamp of the period.",
                    "type": "long"
                }
            ],
            "type": "Map<String, io.apisense.sting.phone.system.ApplicationUsageStats>"
        },
        {
            "name": "applicationUsageStatsForPackage",
            "description": "Get the usage stats for the given application and the given period. The method return null if the user did not allow the application to access the usage stats or if the version of the SDK is not compatible (min. 22).",
            "parameters": [
                {
                    "name": "startTimestamp",
                    "description": "The start timestamp of the period.",
                    "type": "long"
                },
                {
                    "name": "endTimestamp",
                    "description": "The end timestamp of the period.",
                    "type": "long"
                },
                {
                    "name": "packageName",
                    "description": "The application/service package name.",
                    "type": "String"
                }
            ],
            "type": "Map<String, io.apisense.sting.phone.system.ApplicationUsageStats>"
        },
        {
            "name": "packageNames",
            "description": "Get the package names of the application/service. If the uid is not found on the phone, null is returned.",
            "parameters": [
                {
                    "name": "uid",
                    "description": "The uid of the application/service.",
                    "type": "Integer"
                }
            ],
            "type": "List<String>"
        },
        {
            "name": "applicationNames",
            "description": "Get the names of the application/service. If the uid is not found on the phone, null is returned.",
            "parameters": [
                {
                    "name": "uid",
                    "description": "The uid of the application/service.",
                    "type": "Integer"
                }
            ],
            "type": "List<String>"
        }
    ],
    "sprouts": [
        {
            "event": "screen:unlocked",
            "description": "Send an event when the device is locked or unlocked"
        },
        {
            "event": "screenState:changed",
            "description": "Send an event when the screen is turned on or off"
        },
        {
            "event": "foregroundApp:changed",
            "description": "Send an event when the user changes the foreground app"
        }
    ]
}
