/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone.call;

import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.telephony.CellIdentityGsm;
import android.telephony.CellIdentityLte;
import android.telephony.CellIdentityWcdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.NeighboringCellInfo;

public class Cell {
    public static final String GSM = "GSM";
    public static final String LTE = "LTE";
    public static final String WCDMA = "WCDMA";
    public final String networkType;
    public final Integer cid;
    public final Integer lac;
    public final Integer mcc;
    public final Integer mnc;
    public final Integer rssi;
    public final Integer signalLevel;

    Cell(String networkType, int cid, int lac, int mcc, int mnc, int rssi, int signalLevel) {
        this.networkType = networkType;
        this.cid = this.filterUnknown(cid);
        this.lac = this.filterUnknown(lac);
        this.mcc = this.filterUnknown(mcc);
        this.mnc = this.filterUnknown(mnc);
        this.rssi = this.filterUnknown(rssi);
        this.signalLevel = this.filterUnknown(signalLevel);
    }

    private Integer filterUnknown(int input) {
        return input != Integer.MAX_VALUE ? Integer.valueOf(input) : null;
    }

    @RequiresApi(api=17)
    public static Cell getCellInfo(CellInfoGsm cellInfo) {
        CellIdentityGsm cellId = cellInfo.getCellIdentity();
        CellSignalStrengthGsm cellSignal = cellInfo.getCellSignalStrength();
        return new Cell(GSM, cellId.getCid(), cellId.getLac(), cellId.getMcc(), cellId.getMnc(), cellSignal.getDbm(), cellSignal.getLevel());
    }

    @RequiresApi(api=17)
    public static Cell getCellInfo(CellInfoLte cellInfo) {
        CellIdentityLte cellId = cellInfo.getCellIdentity();
        CellSignalStrengthLte cellSignal = cellInfo.getCellSignalStrength();
        return new Cell(LTE, cellId.getCi(), cellId.getTac(), cellId.getMcc(), cellId.getMnc(), cellSignal.getDbm(), cellSignal.getLevel());
    }

    @RequiresApi(api=18)
    public static Cell getCellInfo(CellInfoWcdma cellInfo) {
        CellIdentityWcdma cellId = cellInfo.getCellIdentity();
        CellSignalStrengthWcdma cellSignal = cellInfo.getCellSignalStrength();
        return new Cell(WCDMA, cellId.getCid(), cellId.getLac(), cellId.getMcc(), cellId.getMnc(), cellSignal.getDbm(), cellSignal.getLevel());
    }

    public static Cell getCellInfo(NeighboringCellInfo neighbor, int networkType, String networkOperator) {
        String mcc = networkOperator.substring(0, 3);
        String mnc = networkOperator.substring(3);
        int asu = neighbor.getRssi();
        String networkName = Cell.findNetworkName(networkType);
        int rssiDBm = Cell.getDBm(networkName, asu);
        return new Cell(networkName, neighbor.getCid(), neighbor.getLac(), Cell.toInteger(mcc), Cell.toInteger(mnc), rssiDBm, Integer.MAX_VALUE);
    }

    private static int getDBm(String networkName, int asu) {
        if (asu == 99) {
            return Integer.MAX_VALUE;
        }
        switch (networkName) {
            case "GSM": {
                return 2 * asu - 113;
            }
            case "WCDMA": {
                return asu - 116;
            }
            case "LTE": {
                return asu - 140;
            }
        }
        return Integer.MAX_VALUE;
    }

    @Nullable
    private static String findNetworkName(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return GSM;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return WCDMA;
            }
            case 13: {
                return LTE;
            }
        }
        return null;
    }

    private static int toInteger(String code) {
        try {
            return Integer.valueOf(code);
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }
}

