/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.sting.phone.system;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

public abstract class ScreenStateReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action.equals("android.intent.action.SCREEN_ON")) {
            this.onScreenOn();
        }
        if (action.equals("android.intent.action.SCREEN_OFF")) {
            this.onScreenOff();
        }
        KeyguardManager kgMan = (KeyguardManager)context.getSystemService("keyguard");
        if (Build.VERSION.SDK_INT >= 16 && action.equals("android.intent.action.USER_PRESENT") && kgMan.isKeyguardSecure()) {
            this.onScreenUnlocked();
        }
    }

    protected abstract void onScreenUnlocked();

    public abstract void onScreenOn();

    public abstract void onScreenOff();
}

