/*
 * Decompiled with CFR 0.152.
 */
package io.apitestbase.core.teststep;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQTopic;
import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.MQHeader;
import com.ibm.mq.headers.MQHeaderIterator;
import com.ibm.mq.headers.MQMD;
import com.ibm.mq.headers.MQRFH2;
import io.apitestbase.core.teststep.TeststepActionRunner;
import io.apitestbase.models.endpoint.Endpoint;
import io.apitestbase.models.endpoint.MqConnectionMode;
import io.apitestbase.models.endpoint.MqEndpointProperties;
import io.apitestbase.models.teststep.MqDestinationType;
import io.apitestbase.models.teststep.MqRfh2Folder;
import io.apitestbase.models.teststep.MqRfh2Header;
import io.apitestbase.models.teststep.MqTeststepProperties;
import io.apitestbase.models.teststep.Teststep;
import io.apitestbase.models.teststep.TeststepActionRunResult;
import io.apitestbase.models.teststep.apirequest.MqEnqueueOrPublishFromFileRequest;
import io.apitestbase.models.teststep.apirequest.MqEnqueueOrPublishFromTextRequest;
import io.apitestbase.models.teststep.apirequest.MqRequest;
import io.apitestbase.models.teststep.apiresponse.ApiResponse;
import io.apitestbase.models.teststep.apiresponse.MqCheckQueueDepthResponse;
import io.apitestbase.models.teststep.apiresponse.MqDequeueResponse;
import io.apitestbase.utils.GeneralUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTeststepActionRunner
extends TeststepActionRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MQTeststepActionRunner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TeststepActionRunResult run() throws Exception {
        Teststep teststep = this.getTeststep();
        String action = teststep.getAction();
        if (teststep.getAction() == null) {
            throw new Exception("Action not specified.");
        }
        MqTeststepProperties teststepProperties = (MqTeststepProperties)teststep.getOtherProperties();
        if (teststepProperties.getDestinationType() == null) {
            throw new Exception("Destination type not specified.");
        }
        TeststepActionRunResult basicTeststepRun = new TeststepActionRunResult();
        ApiResponse response = null;
        Endpoint endpoint = teststep.getEndpoint();
        MqEndpointProperties endpointProperties = (MqEndpointProperties)endpoint.getOtherProperties();
        MQQueueManager queueManager = null;
        try {
            if (endpointProperties.getConnectionMode() == MqConnectionMode.BINDINGS) {
                queueManager = new MQQueueManager(endpointProperties.getQueueManagerName());
            } else {
                Hashtable<String, Object> qmConnProperties = new Hashtable<String, Object>();
                qmConnProperties.put("hostname", endpoint.getHost());
                qmConnProperties.put("port", endpoint.getPort());
                qmConnProperties.put("channel", endpointProperties.getSvrConnChannelName());
                queueManager = new MQQueueManager(endpointProperties.getQueueManagerName(), qmConnProperties);
            }
            if (MqDestinationType.QUEUE == teststepProperties.getDestinationType()) {
                response = this.doQueueAction(queueManager, teststepProperties.getQueueName(), action, (MqRequest)teststep.getApiRequest());
            } else if (MqDestinationType.TOPIC == teststepProperties.getDestinationType()) {
                this.doTopicAction(queueManager, teststepProperties.getTopicString(), action, (MqRequest)teststep.getApiRequest());
            }
        }
        finally {
            if (queueManager != null) {
                queueManager.disconnect();
            }
        }
        basicTeststepRun.setResponse(response);
        return basicTeststepRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApiResponse doQueueAction(MQQueueManager queueManager, String queueName, String action, MqRequest apiRequest) throws Exception {
        MqCheckQueueDepthResponse response;
        block14: {
            response = null;
            int openOptions = 8194;
            try (MQQueue queue = null;){
                if ("CheckDepth".equals(action)) {
                    openOptions += 32;
                } else if ("Enqueue".equals(action)) {
                    openOptions += 16;
                }
                try {
                    queue = queueManager.accessQueue(queueName, openOptions, null, null, null);
                }
                catch (MQException mqEx) {
                    if (mqEx.getCompCode() == 2 && mqEx.getReason() == 2085) {
                        throw new Exception("Queue \"" + queueName + "\" not found.");
                    }
                    throw mqEx;
                }
                if ("Clear".equals(action)) {
                    this.clearQueue(queue);
                    break block14;
                }
                if ("CheckDepth".equals(action)) {
                    response = new MqCheckQueueDepthResponse();
                    response.setQueueDepth(queue.getCurrentDepth());
                    break block14;
                }
                if ("Dequeue".equals(action)) {
                    response = this.dequeue(queue);
                    break block14;
                }
                if ("Enqueue".equals(action)) {
                    this.enqueue(queue, apiRequest);
                    break block14;
                }
                throw new Exception("Unrecognized action " + action + ".");
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTopicAction(MQQueueManager queueManager, String topicString, String action, MqRequest apiRequest) throws Exception {
        block6: {
            if ("".equals(StringUtils.trimToEmpty((String)topicString))) {
                throw new Exception("Topic string not specified.");
            }
            try (MQTopic publisher = null;){
                publisher = queueManager.accessTopic(topicString, null, 2, 16);
                if ("Publish".equals(action)) {
                    MQMessage message = this.buildMessage(apiRequest);
                    publisher.put(message);
                    break block6;
                }
                throw new Exception("Unrecognized action " + action + ".");
            }
        }
    }

    private MQMessage buildMessage(MqRequest apiRequest) throws Exception {
        MQMessage message;
        if (apiRequest instanceof MqEnqueueOrPublishFromTextRequest) {
            MqEnqueueOrPublishFromTextRequest request = (MqEnqueueOrPublishFromTextRequest)apiRequest;
            message = this.buildMessageFromText(request.getBody(), request.getRfh2Header());
        } else {
            MqEnqueueOrPublishFromFileRequest request = (MqEnqueueOrPublishFromFileRequest)apiRequest;
            message = this.buildMessageFromFile(request.getFileContent());
        }
        return message;
    }

    private void enqueue(MQQueue queue, MqRequest apiRequest) throws Exception {
        MQMessage message = this.buildMessage(apiRequest);
        MQPutMessageOptions pmo = new MQPutMessageOptions();
        queue.put(message, pmo);
    }

    private MQMessage buildMessageFromText(String body, MqRfh2Header rfh2Header) throws IOException, MQDataException {
        if (body == null) {
            throw new IllegalArgumentException("Message body can not be null.");
        }
        MQMessage message = new MQMessage();
        MQMD mqmd = new MQMD();
        message.putDateTime = new GregorianCalendar();
        mqmd.setEncoding(546);
        if (rfh2Header == null) {
            mqmd.copyTo((com.ibm.mq.MQMD)message);
        } else {
            mqmd.setFormat("MQHRF2  ");
            mqmd.setCodedCharSetId(0);
            mqmd.setPersistence(1);
            mqmd.copyTo((com.ibm.mq.MQMD)message);
            MQRFH2 mqrfh2 = new MQRFH2();
            mqrfh2.setFolderStrings(rfh2Header.getFolderStrings());
            mqrfh2.write((DataOutput)message);
        }
        message.writeString(body);
        return message;
    }

    private MQMessage buildMessageFromFile(byte[] bytes) throws MQDataException, IOException {
        MQMD mqmdHeader;
        if (bytes == null) {
            throw new IllegalArgumentException("File can not be null.");
        }
        MQMessage message = new MQMessage();
        try {
            mqmdHeader = new MQMD((DataInput)new DataInputStream(new ByteArrayInputStream(bytes)), 546, 0);
        }
        catch (Exception e) {
            LOGGER.info("Not able to construct MQMD out of the bytes. Exception details: ", (Throwable)e);
            mqmdHeader = null;
        }
        if (mqmdHeader != null && "MD  ".equals(mqmdHeader.getStrucId()) && (1 == mqmdHeader.getVersion() || 2 == mqmdHeader.getVersion())) {
            LOGGER.info("MQMD constructed. Writing other bytes as application data.");
            message.putDateTime = new GregorianCalendar();
            mqmdHeader.copyTo((com.ibm.mq.MQMD)message);
            message.persistence = 1;
            message.write(bytes, 364, bytes.length - 364);
        } else {
            LOGGER.info("No valid MQMD. Writing all bytes as application data.");
            message.write(bytes);
        }
        return message;
    }

    private MqDequeueResponse dequeue(MQQueue queue) throws MQException, IOException, MQDataException {
        MqDequeueResponse result;
        block4: {
            result = null;
            MQGetMessageOptions getOptions = new MQGetMessageOptions();
            getOptions.options = 0x2002000;
            MQMessage message = new MQMessage();
            try {
                queue.get(message, getOptions);
                result = new MqDequeueResponse();
                MqRfh2Header mqrfh2Header = null;
                MQHeaderIterator it = new MQHeaderIterator((DataInput)message);
                while (it.hasNext()) {
                    MQHeader header = it.nextHeader();
                    if (!(header instanceof MQRFH2)) continue;
                    mqrfh2Header = new MqRfh2Header();
                    MQRFH2 mqrfh2 = (MQRFH2)header;
                    String[] folderStrings = mqrfh2.getFolderStrings();
                    for (int i = 0; i < folderStrings.length; ++i) {
                        MqRfh2Folder mqrfh2Folder = new MqRfh2Folder();
                        mqrfh2Folder.setString(folderStrings[i]);
                        GeneralUtils.validateMQRFH2FolderStringAndSetFolderName((MqRfh2Folder)mqrfh2Folder);
                        mqrfh2Header.getFolders().add(mqrfh2Folder);
                    }
                }
                result.setMqrfh2Header(mqrfh2Header);
                result.setBodyAsText(it.getBodyAsText());
            }
            catch (MQException mqEx) {
                if (mqEx.getCompCode() == 2 && mqEx.getReason() == 2033) break block4;
                throw mqEx;
            }
        }
        return result;
    }

    private void clearQueue(MQQueue queue) throws MQException {
        MQGetMessageOptions getOptions = new MQGetMessageOptions();
        getOptions.options = 8192;
        while (true) {
            MQMessage message = new MQMessage();
            try {
                queue.get(message, getOptions);
            }
            catch (MQException mqEx) {
                if (mqEx.getCompCode() != 2 || mqEx.getReason() != 2033) {
                    throw mqEx;
                }
                return;
            }
        }
    }
}

