/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.gson.JsonParser;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MobileElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.openqa.selenium.remote.RemoteWebElement;

public class ComplexFind {
    private AppiumDriver driver;
    private static final HttpClient client = HttpClients.createDefault();
    private static final JsonParser parser = new JsonParser();

    public ComplexFind(AppiumDriver driver) {
        this.driver = driver;
    }

    private MobileElement newElement(String elementId) {
        MobileElement element = new MobileElement(new RemoteWebElement(), this.driver);
        element.setParent(this.driver);
        element.setId(elementId);
        element.setFileDetector(this.driver.getFileDetector());
        return element;
    }

    protected MobileElement scrollTo(String text) {
        text = text.replaceAll("\"", "\\\"");
        String complex = "[\"scroll\",[[3,\"" + text + "\"]],[[7,\"" + text + "\"]]]";
        return this.execute(complex);
    }

    protected MobileElement scrollToExact(String text) {
        text = text.replaceAll("\"", "\\\"");
        String complex = "[\"scroll\",[[1,\"" + text + "\"]],[[5,\"" + text + "\"]]]";
        return this.execute(complex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MobileElement execute(String complex) {
        MobileElement element;
        block7: {
            element = null;
            try {
                String id = this.driver.getSessionId().toString();
                String executeURL = this.driver.getRemoteAddress() + "/session/" + id + "/appium/app/complex_find";
                HttpPost post = new HttpPost(executeURL);
                post.setEntity((HttpEntity)new StringEntity(complex, "UTF8"));
                post.setHeader("Content-type", "application/json");
                HttpEntity responseEntity = client.execute((HttpUriRequest)post).getEntity();
                if (responseEntity == null) break block7;
                try {
                    String responseString = EntityUtils.toString((HttpEntity)responseEntity);
                    String elementId = parser.parse(responseString).getAsJsonObject().get("value").getAsJsonObject().get("ELEMENT").getAsString();
                    element = this.newElement(elementId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    EntityUtils.consume((HttpEntity)responseEntity);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return element;
    }
}

