/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.MobileElement;
import io.appium.java_client.android.AndroidElement;
import io.appium.java_client.ios.IOSElement;
import io.appium.java_client.pagefactory.AppiumElementLocatorFactory;
import io.appium.java_client.pagefactory.ElementInterceptor;
import io.appium.java_client.pagefactory.ElementListInterceptor;
import io.appium.java_client.pagefactory.ProxyFactory;
import io.appium.java_client.pagefactory.ResetsImplicitlyWaitTimeOut;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class AppiumFieldDecorator
implements FieldDecorator,
ResetsImplicitlyWaitTimeOut {
    private static final List<Class<? extends WebElement>> availableElementClasses = new ArrayList<Class<? extends WebElement>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(WebElement.class);
            this.add(RemoteWebElement.class);
            this.add(MobileElement.class);
            this.add(AndroidElement.class);
            this.add(IOSElement.class);
        }
    };
    private final AppiumElementLocatorFactory factory;
    public static long DEFAULT_IMPLICITLY_WAIT_TIMEOUT = 1L;
    public static TimeUnit DEFAULT_TIMEUNIT = TimeUnit.SECONDS;

    public AppiumFieldDecorator(SearchContext context, long implicitlyWaitTimeOut, TimeUnit timeUnit) {
        this.factory = new AppiumElementLocatorFactory(context, implicitlyWaitTimeOut, timeUnit);
    }

    public AppiumFieldDecorator(SearchContext context) {
        this.factory = new AppiumElementLocatorFactory(context);
    }

    public Object decorate(ClassLoader ignored, Field field) {
        if (!availableElementClasses.contains(field.getType()) && !this.isDecoratableList(field)) {
            return null;
        }
        ElementLocator locator = this.factory.createLocator(field);
        if (locator == null) {
            return null;
        }
        if (WebElement.class.isAssignableFrom(field.getType())) {
            return this.proxyForLocator(field, locator);
        }
        if (List.class.isAssignableFrom(field.getType())) {
            return this.proxyForListLocator(locator);
        }
        return null;
    }

    private static boolean isAvailableElementClass(Type type) {
        boolean result = false;
        for (Class<? extends WebElement> webElementClass : availableElementClasses) {
            if (!webElementClass.equals(type)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isDecoratableList(Field field) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        return AppiumFieldDecorator.isAvailableElementClass(listType);
    }

    private Object proxyForLocator(Field field, ElementLocator locator) {
        Class<Object> type = field.getType();
        if (type.equals(WebElement.class)) {
            type = RemoteWebElement.class;
        }
        ElementInterceptor elementInterceptor = new ElementInterceptor(locator);
        return ProxyFactory.getEnhancedProxy(type, elementInterceptor);
    }

    private List<WebElement> proxyForListLocator(ElementLocator locator) {
        ElementListInterceptor elementInterceptor = new ElementListInterceptor(locator);
        return ProxyFactory.getEnhancedProxy(ArrayList.class, elementInterceptor);
    }

    @Override
    public void resetImplicitlyWaitTimeOut(long timeOut, TimeUnit timeUnit) {
        this.factory.resetImplicitlyWaitTimeOut(timeOut, timeUnit);
    }
}

