/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.service.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.InvalidNodeJSInstance;
import io.appium.java_client.service.local.InvalidServerInstanceException;
import io.appium.java_client.service.local.Scripts;
import io.appium.java_client.service.local.flags.ServerArgument;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.service.DriverService;

public final class AppiumServiceBuilder
extends DriverService.Builder<AppiumDriverLocalService, AppiumServiceBuilder> {
    public static final String APPIUM_PATH = "APPIUM_BINARY_PATH";
    public static final String NODE_PATH = "NODE_BINARY_PATH";
    private static final List<String> PATH_CAPABILITIES = new ArrayList<String>(){
        {
            this.add("keystorePath");
            this.add("chromedriverExecutable");
            this.add("app");
        }
    };
    private static final String APPIUM_FOLDER = "appium";
    private static final String BIN_FOLDER = "bin";
    private static final String BUILD_FOLDER = "build";
    private static final String LIB_FOLDER = "lib";
    private static final String APPIUM_JS = "appium.js";
    private static final String MAIN_JS = "main.js";
    private static final String ERROR_NODE_NOT_FOUND = "There is no installed nodes! Please install node via NPM (https://www.npmjs.com/package/appium#using-node-js) or download and install Appium app (http://appium.io/downloads.html)";
    private static final String APPIUM_NODE_MASK_OLD = String.valueOf(File.separator) + "bin" + File.separator + "appium.js";
    private static final String APPIUM_NODE_MASK = String.valueOf(File.separator) + "build" + File.separator + "lib" + File.separator + "main.js";
    public static final String DEFAULT_LOCAL_IP_ADDRESS = "0.0.0.0";
    private static final int DEFAULT_APPIUM_PORT = 4723;
    private static final String BASH = "bash";
    private static final String CMD_EXE = "cmd.exe";
    private static final String NODE = "node";
    final Map<String, String> serverArguments = new HashMap<String, String>();
    private File appiumJS;
    private String ipAddress = "0.0.0.0";
    private File npmScript;
    private File getNodeJSExecutable;
    private DesiredCapabilities capabilities;
    private long startupTimeout = 120L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;

    private void setUpNPMScript() {
        if (this.npmScript != null) {
            return;
        }
        if (!Platform.getCurrent().is(Platform.WINDOWS)) {
            this.npmScript = Scripts.GET_PATH_TO_DEFAULT_NODE_UNIX.getScriptFile();
        }
    }

    private void setUpGetNodeJSExecutableScript() {
        if (this.getNodeJSExecutable != null) {
            return;
        }
        this.getNodeJSExecutable = Scripts.GET_NODE_JS_EXECUTABLE.getScriptFile();
    }

    private File findNodeInCurrentFileSystem() {
        CommandLine commandLine;
        this.setUpNPMScript();
        try {
            commandLine = Platform.getCurrent().is(Platform.WINDOWS) ? new CommandLine(CMD_EXE, new String[]{"/C", "npm root -g"}) : new CommandLine(BASH, new String[]{"-l", this.npmScript.getAbsolutePath()});
            commandLine.execute();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        String instancePath = commandLine.getStdOut().trim();
        try {
            File defaultAppiumNode;
            if (StringUtils.isBlank((CharSequence)instancePath) || !(defaultAppiumNode = new File(String.valueOf(instancePath) + File.separator + APPIUM_FOLDER)).exists()) {
                String errorOutput = commandLine.getStdOut();
                throw new InvalidServerInstanceException(ERROR_NODE_NOT_FOUND, new IOException(errorOutput));
            }
            File oldResult = new File(defaultAppiumNode, APPIUM_NODE_MASK_OLD);
            if (oldResult.exists()) {
                File file = oldResult;
                return file;
            }
            File newResult = new File(defaultAppiumNode, APPIUM_NODE_MASK);
            if (newResult.exists()) {
                File file = newResult;
                return file;
            }
            throw new InvalidServerInstanceException(ERROR_NODE_NOT_FOUND, new IOException("Could not find file neither " + APPIUM_NODE_MASK_OLD + " nor " + APPIUM_NODE_MASK + " in the " + defaultAppiumNode + " directory"));
        }
        finally {
            commandLine.destroy();
        }
    }

    private static void validateNodeStructure(File node) {
        String absoluteNodePath = node.getAbsolutePath();
        if (!node.exists()) {
            throw new InvalidServerInstanceException("The invalid appium node " + absoluteNodePath + " has been defined", new IOException("The node " + absoluteNodePath + "doesn't exist"));
        }
    }

    public AppiumServiceBuilder() {
        this.usingPort(4723);
    }

    protected File findDefaultExecutable() {
        CommandLine commandLine;
        File result;
        String nodeJSExec = System.getProperty(NODE_PATH);
        if (StringUtils.isBlank((CharSequence)nodeJSExec)) {
            nodeJSExec = System.getenv(NODE_PATH);
        }
        if (!StringUtils.isBlank((CharSequence)nodeJSExec) && (result = new File(nodeJSExec)).exists()) {
            return result;
        }
        this.setUpGetNodeJSExecutableScript();
        try {
            commandLine = Platform.getCurrent().is(Platform.WINDOWS) ? new CommandLine("node.exe", new String[]{this.getNodeJSExecutable.getAbsolutePath()}) : new CommandLine(NODE, new String[]{this.getNodeJSExecutable.getAbsolutePath()});
            commandLine.execute();
        }
        catch (Throwable t) {
            throw new InvalidNodeJSInstance("Node.js is not installed!", t);
        }
        String filePath = commandLine.getStdOut().trim();
        try {
            if (StringUtils.isBlank((CharSequence)filePath) || !new File(filePath).exists()) {
                String errorOutput = commandLine.getStdOut();
                String errorMessage = "Can't get a path to the default Node.js instance";
                throw new InvalidNodeJSInstance(errorMessage, new IOException(errorOutput));
            }
            File file = new File(filePath);
            return file;
        }
        finally {
            commandLine.destroy();
        }
    }

    public AppiumServiceBuilder withArgument(ServerArgument argument) {
        this.serverArguments.put(argument.getArgument(), "");
        return this;
    }

    public AppiumServiceBuilder withArgument(ServerArgument argument, String value) {
        this.serverArguments.put(argument.getArgument(), value);
        return this;
    }

    public AppiumServiceBuilder withCapabilities(DesiredCapabilities capabilities) {
        if (this.capabilities == null) {
            this.capabilities = capabilities;
        } else {
            DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
            desiredCapabilities.merge((Capabilities)this.capabilities).merge((Capabilities)capabilities);
            this.capabilities = desiredCapabilities;
        }
        return this;
    }

    public AppiumServiceBuilder withAppiumJS(File appiumJS) {
        this.appiumJS = appiumJS;
        return this;
    }

    public AppiumServiceBuilder withIPAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public AppiumServiceBuilder withStartUpTimeOut(long time, TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)((Object)timeUnit));
        Preconditions.checkArgument((time > 0L ? 1 : 0) != 0, (String)"Time value should be greater than zero", (Object[])new Object[]{time});
        this.startupTimeout = time;
        this.timeUnit = timeUnit;
        return this;
    }

    void checkAppiumJS() {
        if (this.appiumJS != null) {
            AppiumServiceBuilder.validateNodeStructure(this.appiumJS);
            return;
        }
        String appiumJS = System.getProperty(APPIUM_PATH);
        if (StringUtils.isBlank((CharSequence)appiumJS)) {
            appiumJS = System.getenv(APPIUM_PATH);
        }
        if (!StringUtils.isBlank((CharSequence)appiumJS)) {
            File node = new File(appiumJS);
            AppiumServiceBuilder.validateNodeStructure(node);
            this.appiumJS = node;
            return;
        }
        this.appiumJS = this.findNodeInCurrentFileSystem();
    }

    private String parseCapabilitiesIfWindows() {
        String result = "";
        if (this.capabilities != null) {
            Map capabilitiesMap = this.capabilities.asMap();
            Set entries = capabilitiesMap.entrySet();
            for (Map.Entry entry : entries) {
                Object value = entry.getValue();
                if (value == null) continue;
                value = String.class.isAssignableFrom(value.getClass()) ? (PATH_CAPABILITIES.contains(entry.getKey()) ? "\\\"" + String.valueOf(value).replace("\\", "/") + "\\\"" : "\\\"" + String.valueOf(value) + "\\\"") : String.valueOf(value);
                String key = "\\\"" + String.valueOf(entry.getKey()) + "\\\"";
                result = StringUtils.isBlank((CharSequence)result) ? String.valueOf(key) + ": " + value : String.valueOf(result) + ", " + key + ": " + value;
            }
        }
        return "{" + result + "}";
    }

    private String parseCapabilitiesIfUNIX() {
        String result = "";
        if (this.capabilities != null) {
            Map capabilitiesMap = this.capabilities.asMap();
            Set entries = capabilitiesMap.entrySet();
            for (Map.Entry entry : entries) {
                Object value = entry.getValue();
                if (value == null) continue;
                value = String.class.isAssignableFrom(value.getClass()) ? "\"" + String.valueOf(value) + "\"" : String.valueOf(value);
                String key = "\"" + String.valueOf(entry.getKey()) + "\"";
                result = StringUtils.isBlank((CharSequence)result) ? String.valueOf(key) + ": " + value : String.valueOf(result) + ", " + key + ": " + value;
            }
        }
        return "{" + result + "}";
    }

    private String parseCapabilities() {
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            return this.parseCapabilitiesIfWindows();
        }
        return this.parseCapabilitiesIfUNIX();
    }

    protected ImmutableList<String> createArgs() {
        ArrayList<String> argList = new ArrayList<String>();
        this.checkAppiumJS();
        argList.add(this.appiumJS.getAbsolutePath());
        argList.add("--port");
        argList.add(String.valueOf(this.getPort()));
        if (StringUtils.isBlank((CharSequence)this.ipAddress)) {
            this.ipAddress = DEFAULT_LOCAL_IP_ADDRESS;
        } else {
            InetAddressValidator validator = InetAddressValidator.getInstance();
            if (!(validator.isValid(this.ipAddress) || validator.isValidInet4Address(this.ipAddress) || validator.isValidInet6Address(this.ipAddress))) {
                throw new IllegalArgumentException("The invalid IP address " + this.ipAddress + " is defined");
            }
        }
        argList.add("--address");
        argList.add(this.ipAddress);
        File log = this.getLogFile();
        if (log != null) {
            argList.add("--log");
            argList.add(log.getAbsolutePath());
        }
        Set<Map.Entry<String, String>> entries = this.serverArguments.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String argument = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank((CharSequence)argument) || value == null) continue;
            argList.add(argument);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            argList.add(value);
        }
        if (this.capabilities != null) {
            argList.add("--default-capabilities");
            argList.add(this.parseCapabilities());
        }
        return new ImmutableList.Builder().addAll(argList).build();
    }

    public AppiumServiceBuilder usingDriverExecutable(File nodeJSExecutable) {
        return (AppiumServiceBuilder)super.usingDriverExecutable(nodeJSExecutable);
    }

    public AppiumServiceBuilder usingPort(int port) {
        return (AppiumServiceBuilder)super.usingPort(port);
    }

    public AppiumServiceBuilder usingAnyFreePort() {
        return (AppiumServiceBuilder)super.usingAnyFreePort();
    }

    public AppiumServiceBuilder withEnvironment(Map<String, String> environment) {
        return (AppiumServiceBuilder)super.withEnvironment(environment);
    }

    public AppiumServiceBuilder withLogFile(File logFile) {
        return (AppiumServiceBuilder)super.withLogFile(logFile);
    }

    protected AppiumDriverLocalService createDriverService(File nodeJSExecutable, int nodeJSPort, ImmutableList<String> nodeArguments, ImmutableMap<String, String> nodeEnvironment) {
        try {
            return new AppiumDriverLocalService(this.ipAddress, nodeJSExecutable, nodeJSPort, nodeArguments, nodeEnvironment, this.startupTimeout, this.timeUnit);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void disposeCachedFile(File file) {
        if (file != null) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException iOException) {}
        }
    }

    protected void finalize() throws Throwable {
        AppiumServiceBuilder.disposeCachedFile(this.npmScript);
        AppiumServiceBuilder.disposeCachedFile(this.getNodeJSExecutable);
        super.finalize();
    }
}

