/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.AppiumSetting;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.NetworkConnectionSetting;
import io.appium.java_client.android.AndroidDeviceActionShortcuts;
import io.appium.java_client.android.Connection;
import io.appium.java_client.android.HasNetworkConnection;
import io.appium.java_client.android.PushesFiles;
import io.appium.java_client.android.StartsActivity;
import io.appium.java_client.android.internal.JsonToAndroidElementConverter;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpClient;

public class AndroidDriver<T extends WebElement>
extends AppiumDriver<T>
implements AndroidDeviceActionShortcuts,
HasNetworkConnection,
PushesFiles,
StartsActivity,
FindsByAndroidUIAutomator<T> {
    private static final String ANDROID_PLATFORM = "Android";

    public AndroidDriver(HttpCommandExecutor executor, Capabilities capabilities) {
        super(executor, capabilities, JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(remoteAddress, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(AppiumDriverLocalService service, Capabilities desiredCapabilities) {
        super(service, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(service, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(AppiumServiceBuilder builder, Capabilities desiredCapabilities) {
        super(builder, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(builder, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(Capabilities desiredCapabilities) {
        super(AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    @Override
    public void swipe(int startx, int starty, int endx, int endy, int duration) {
        this.doSwipe(startx, starty, endx, endy, duration);
    }

    @Deprecated
    static String uiScrollable(String uiSelector) {
        return "new UiScrollable(new UiSelector().scrollable(true).instance(0)).scrollIntoView(" + uiSelector + ".instance(0));";
    }

    @Override
    @Deprecated
    public T scrollTo(String text) {
        String uiScrollables = String.valueOf(AndroidDriver.uiScrollable("new UiSelector().descriptionContains(\"" + text + "\")")) + AndroidDriver.uiScrollable("new UiSelector().textContains(\"" + text + "\")");
        return this.findElementByAndroidUIAutomator(uiScrollables);
    }

    @Override
    @Deprecated
    public T scrollToExact(String text) {
        String uiScrollables = String.valueOf(AndroidDriver.uiScrollable("new UiSelector().description(\"" + text + "\")")) + AndroidDriver.uiScrollable("new UiSelector().text(\"" + text + "\")");
        return this.findElementByAndroidUIAutomator(uiScrollables);
    }

    @Override
    public void pressKeyCode(int key) {
        this.execute("pressKeyCode", (Map)AndroidDriver.getCommandImmutableMap("keycode", key));
    }

    @Override
    public void pressKeyCode(int key, Integer metastate) {
        String[] parameters = new String[]{"keycode", "metastate"};
        Object[] values = new Object[]{key, metastate};
        this.execute("pressKeyCode", (Map)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public void longPressKeyCode(int key) {
        this.execute("longPressKeyCode", (Map)AndroidDriver.getCommandImmutableMap("keycode", key));
    }

    @Override
    public void longPressKeyCode(int key, Integer metastate) {
        String[] parameters = new String[]{"keycode", "metastate"};
        Object[] values = new Object[]{key, metastate};
        this.execute("longPressKeyCode", (Map)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    @Deprecated
    public NetworkConnectionSetting getNetworkConnection() {
        Response response = this.execute("getNetworkConnection");
        return new NetworkConnectionSetting(Integer.parseInt(response.getValue().toString()));
    }

    @Override
    @Deprecated
    public void setNetworkConnection(NetworkConnectionSetting connection) {
        String[] parameters = new String[]{"name", "parameters"};
        Object[] values = new Object[]{"network_connection", ImmutableMap.of((Object)"type", (Object)connection.value)};
        this.execute("setNetworkConnection", (Map)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public void setConnection(Connection connection) {
        String[] parameters = new String[]{"name", "parameters"};
        Object[] values = new Object[]{"network_connection", ImmutableMap.of((Object)"type", (Object)connection.bitMask)};
        this.execute("setNetworkConnection", (Map)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public Connection getConnection() {
        Connection[] types;
        Response response = this.execute("getNetworkConnection");
        int bitMask = Integer.parseInt(response.getValue().toString());
        Connection[] connectionArray = types = Connection.values();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Connection connection = connectionArray[n2];
            if (connection.bitMask == bitMask) {
                return connection;
            }
            ++n2;
        }
        throw new WebDriverException("The unknown network connection type has been returned. The bitmask is " + bitMask);
    }

    @Override
    public void pushFile(String remotePath, byte[] base64Data) {
        String[] parameters = new String[]{"path", "data"};
        Object[] values = new Object[]{remotePath, base64Data};
        this.execute("pushFile", (Map)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public void pushFile(String remotePath, File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"A reference to file should not be NULL");
        if (!file.exists()) {
            throw new IOException("The given file " + file.getAbsolutePath() + " doesn't exist");
        }
        this.pushFile(remotePath, Base64.encodeBase64((byte[])FileUtils.readFileToByteArray((File)file)));
    }

    @Override
    public void startActivity(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity, String intentAction, String intentCategory, String intentFlags, String optionalIntentArguments, boolean stopApp) throws IllegalArgumentException {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)appPackage) && !StringUtils.isBlank((CharSequence)appActivity) ? 1 : 0) != 0, (Object)String.format("'%s' and '%s' are required.", "appPackage", "appActivity"));
        appWaitPackage = !StringUtils.isBlank((CharSequence)appWaitPackage) ? appWaitPackage : "";
        appWaitActivity = !StringUtils.isBlank((CharSequence)appWaitActivity) ? appWaitActivity : "";
        intentAction = !StringUtils.isBlank((CharSequence)intentAction) ? intentAction : "";
        intentCategory = !StringUtils.isBlank((CharSequence)intentCategory) ? intentCategory : "";
        intentFlags = !StringUtils.isBlank((CharSequence)intentFlags) ? intentFlags : "";
        optionalIntentArguments = !StringUtils.isBlank((CharSequence)optionalIntentArguments) ? optionalIntentArguments : "";
        ImmutableMap parameters = ImmutableMap.builder().put((Object)"appPackage", (Object)appPackage).put((Object)"appActivity", (Object)appActivity).put((Object)"appWaitPackage", (Object)appWaitPackage).put((Object)"appWaitActivity", (Object)appWaitActivity).put((Object)"dontStopAppOnReset", (Object)(!stopApp ? 1 : 0)).put((Object)"intentAction", (Object)intentAction).put((Object)"intentCategory", (Object)intentCategory).put((Object)"intentFlags", (Object)intentFlags).put((Object)"optionalIntentArguments", (Object)optionalIntentArguments).build();
        this.execute("startActivity", (Map)parameters);
    }

    @Override
    public void startActivity(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity, boolean stopApp) throws IllegalArgumentException {
        this.startActivity(appPackage, appActivity, appWaitPackage, appWaitActivity, null, null, null, null, stopApp);
    }

    @Override
    public void startActivity(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity) throws IllegalArgumentException {
        this.startActivity(appPackage, appActivity, appWaitPackage, appWaitActivity, null, null, null, null, true);
    }

    @Override
    public void startActivity(String appPackage, String appActivity) throws IllegalArgumentException {
        this.startActivity(appPackage, appActivity, null, null, null, null, null, null, true);
    }

    @Override
    public void startActivity(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity, String intentAction, String intentCategory, String intentFlags, String intentOptionalArgs) throws IllegalArgumentException {
        this.startActivity(appPackage, appActivity, appWaitPackage, appWaitActivity, intentAction, intentCategory, intentFlags, intentOptionalArgs, true);
    }

    public void endTestCoverage(String intent, String path) {
        String[] parameters = new String[]{"intent", "path"};
        Object[] values = new Object[]{intent, path};
        this.execute("endTestCoverage", (Map)AndroidDriver.getCommandImmutableMap(parameters, values));
    }

    public String currentActivity() {
        Response response = this.execute("currentActivity");
        return response.getValue().toString();
    }

    public void openNotifications() {
        this.execute("openNotifications");
    }

    public boolean isLocked() {
        Response response = this.execute("isLocked");
        return Boolean.parseBoolean(response.getValue().toString());
    }

    public void toggleLocationServices() {
        this.execute("toggleLocationServices");
    }

    public void ignoreUnimportantViews(Boolean compress) {
        this.setSetting(AppiumSetting.IGNORE_UNIMPORTANT_VIEWS, compress);
    }

    @Override
    public T findElementByAndroidUIAutomator(String using) throws WebDriverException {
        return (T)this.findElement("-android uiautomator", using);
    }

    @Override
    public List<T> findElementsByAndroidUIAutomator(String using) throws WebDriverException {
        return this.findElements("-android uiautomator", using);
    }

    public void lockDevice() {
        this.execute("lock", (Map)ImmutableMap.of((Object)"seconds", (Object)0));
    }

    public void unlockDevice() {
        this.execute("unlock");
    }
}

