/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.base.Preconditions;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.AppiumSetting;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.FindsByAndroidUIAutomator;
import io.appium.java_client.android.AndroidDeviceActionShortcuts;
import io.appium.java_client.android.AndroidMobileCommandHelper;
import io.appium.java_client.android.Connection;
import io.appium.java_client.android.HasNetworkConnection;
import io.appium.java_client.android.PushesFiles;
import io.appium.java_client.android.StartsActivity;
import io.appium.java_client.android.internal.JsonToAndroidElementConverter;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.http.HttpClient;

public class AndroidDriver<T extends WebElement>
extends AppiumDriver<T>
implements AndroidDeviceActionShortcuts,
HasNetworkConnection,
PushesFiles,
StartsActivity,
FindsByAndroidUIAutomator<T> {
    private static final String ANDROID_PLATFORM = "Android";

    public AndroidDriver(HttpCommandExecutor executor, Capabilities capabilities) {
        super(executor, capabilities, JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(remoteAddress, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(AppiumDriverLocalService service, Capabilities desiredCapabilities) {
        super(service, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(service, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(AppiumServiceBuilder builder, Capabilities desiredCapabilities) {
        super(builder, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(builder, httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(httpClientFactory, AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    public AndroidDriver(Capabilities desiredCapabilities) {
        super(AndroidDriver.substituteMobilePlatform(desiredCapabilities, ANDROID_PLATFORM), JsonToAndroidElementConverter.class);
    }

    @Override
    public void swipe(int startx, int starty, int endx, int endy, int duration) {
        this.doSwipe(startx, starty, endx, endy, duration);
    }

    @Override
    public void pressKeyCode(int key) {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.pressKeyCodeCommand(key));
    }

    @Override
    public void pressKeyCode(int key, Integer metastate) {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.pressKeyCodeCommand(key, metastate));
    }

    @Override
    public void longPressKeyCode(int key) {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.longPressKeyCodeCommand(key));
    }

    @Override
    public void longPressKeyCode(int key, Integer metastate) {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.longPressKeyCodeCommand(key, metastate));
    }

    @Override
    public void setConnection(Connection connection) {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.setConnectionCommand(connection));
    }

    @Override
    public Connection getConnection() {
        Connection[] types;
        long bitMask = (Long)CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.getNetworkConnectionCommand());
        Connection[] connectionArray = types = Connection.values();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Connection connection = connectionArray[n2];
            if ((long)connection.bitMask == bitMask) {
                return connection;
            }
            ++n2;
        }
        throw new WebDriverException("The unknown network connection type has been returned. The bitmask is " + bitMask);
    }

    @Override
    public void pushFile(String remotePath, byte[] base64Data) {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.pushFileCommandCommand(remotePath, base64Data));
    }

    @Override
    public void pushFile(String remotePath, File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"A reference to file should not be NULL");
        if (!file.exists()) {
            throw new IOException("The given file " + file.getAbsolutePath() + " doesn't exist");
        }
        this.pushFile(remotePath, Base64.encodeBase64((byte[])FileUtils.readFileToByteArray((File)file)));
    }

    @Override
    public void startActivity(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity, String intentAction, String intentCategory, String intentFlags, String optionalIntentArguments, boolean stopApp) throws IllegalArgumentException {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.startActivityCommand(appPackage, appActivity, appWaitPackage, appWaitActivity, intentAction, intentCategory, intentFlags, optionalIntentArguments, stopApp));
    }

    @Override
    public void startActivity(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity, boolean stopApp) throws IllegalArgumentException {
        this.startActivity(appPackage, appActivity, appWaitPackage, appWaitActivity, null, null, null, null, stopApp);
    }

    @Override
    public void startActivity(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity) throws IllegalArgumentException {
        this.startActivity(appPackage, appActivity, appWaitPackage, appWaitActivity, null, null, null, null, true);
    }

    @Override
    public void startActivity(String appPackage, String appActivity) throws IllegalArgumentException {
        this.startActivity(appPackage, appActivity, null, null, null, null, null, null, true);
    }

    @Override
    public void startActivity(String appPackage, String appActivity, String appWaitPackage, String appWaitActivity, String intentAction, String intentCategory, String intentFlags, String intentOptionalArgs) throws IllegalArgumentException {
        this.startActivity(appPackage, appActivity, appWaitPackage, appWaitActivity, intentAction, intentCategory, intentFlags, intentOptionalArgs, true);
    }

    public void endTestCoverage(String intent, String path) {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.endTestCoverageCommand(intent, path));
    }

    public String currentActivity() {
        return (String)CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.currentActivityCommand());
    }

    public void openNotifications() {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.openNotificationsCommand());
    }

    public boolean isLocked() {
        return (Boolean)CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.isLockedCommand());
    }

    public void toggleLocationServices() {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.toggleLocationServicesCommand());
    }

    public void ignoreUnimportantViews(Boolean compress) {
        this.setSetting(AppiumSetting.IGNORE_UNIMPORTANT_VIEWS, compress);
    }

    @Override
    public T findElementByAndroidUIAutomator(String using) throws WebDriverException {
        return (T)this.findElement("-android uiautomator", using);
    }

    @Override
    public List<T> findElementsByAndroidUIAutomator(String using) throws WebDriverException {
        return this.findElements("-android uiautomator", using);
    }

    public void lockDevice() {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.lockDeviceCommand());
    }

    public void unlockDevice() {
        CommandExecutionHelper.execute(this, AndroidMobileCommandHelper.unlockCommand());
    }
}

