/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import io.appium.java_client.AppiumDriver;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.FindsByIosUIAutomation;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.ios.IOSDeviceActionShortcuts;
import io.appium.java_client.ios.IOSMobileCommandHelper;
import io.appium.java_client.ios.internal.JsonToIOSElementConverter;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.security.Credentials;

public class IOSDriver<T extends WebElement>
extends AppiumDriver<T>
implements IOSDeviceActionShortcuts,
FindsByIosUIAutomation<T> {
    private static final String IOS_PLATFORM = "iOS";

    public IOSDriver(HttpCommandExecutor executor, Capabilities capabilities) {
        super(executor, capabilities, JsonToIOSElementConverter.class);
    }

    public IOSDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(remoteAddress, httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(AppiumDriverLocalService service, Capabilities desiredCapabilities) {
        super(service, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(service, httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(AppiumServiceBuilder builder, Capabilities desiredCapabilities) {
        super(builder, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(builder, httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(HttpClient.Factory httpClientFactory, Capabilities desiredCapabilities) {
        super(httpClientFactory, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    public IOSDriver(Capabilities desiredCapabilities) {
        super(IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM), JsonToIOSElementConverter.class);
    }

    @Override
    public void swipe(int startx, int starty, int endx, int endy, int duration) {
        this.doSwipe(startx, starty, endx - startx, endy - starty, duration);
    }

    @Override
    public void hideKeyboard(String strategy, String keyName) {
        CommandExecutionHelper.execute(this, IOSMobileCommandHelper.hideKeyboardCommand(strategy, keyName));
    }

    @Override
    public void hideKeyboard(String keyName) {
        CommandExecutionHelper.execute(this, IOSMobileCommandHelper.hideKeyboardCommand(keyName));
    }

    @Override
    public void shake() {
        CommandExecutionHelper.execute(this, IOSMobileCommandHelper.shakeCommand());
    }

    @Override
    public T findElementByIosUIAutomation(String using) throws WebDriverException {
        return (T)this.findElement("-ios uiautomation", using);
    }

    @Override
    public List<T> findElementsByIosUIAutomation(String using) throws WebDriverException {
        return this.findElements("-ios uiautomation", using);
    }

    public void lockDevice(int seconds) {
        CommandExecutionHelper.execute(this, IOSMobileCommandHelper.lockDeviceCommand(seconds));
    }

    @Override
    public WebDriver.TargetLocator switchTo() {
        return new InnerTargetLocator();
    }

    class IOSAlert
    implements Alert {
        private final Alert alert;

        IOSAlert(Alert alert) {
            this.alert = alert;
        }

        public void dismiss() {
            IOSDriver.this.execute("dismissAlert");
        }

        public void accept() {
            IOSDriver.this.execute("acceptAlert");
        }

        public String getText() {
            Response response = IOSDriver.this.execute("getAlertText");
            return response.getValue().toString();
        }

        public void sendKeys(String keysToSend) {
            IOSDriver.this.execute("setAlertValue", (Map)MobileCommand.prepareArguments("value", keysToSend));
        }

        public void setCredentials(Credentials credentials) {
            this.alert.setCredentials(credentials);
        }

        public void authenticateUsing(Credentials credentials) {
            this.alert.authenticateUsing(credentials);
        }
    }

    private class InnerTargetLocator
    extends RemoteWebDriver.RemoteTargetLocator {
        private InnerTargetLocator() {
            super((RemoteWebDriver)IOSDriver.this);
        }

        public Alert alert() {
            return new IOSAlert(super.alert());
        }
    }
}

