/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.ws.StringWebSocketClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.openqa.selenium.remote.RemoteWebDriver;

public interface ListensToLogcatMessages
extends ExecutesMethod {
    public static final StringWebSocketClient logcatClient = new StringWebSocketClient();

    default public void startLogcatBroadcast() {
        this.startLogcatBroadcast("localhost", 4723);
    }

    default public void startLogcatBroadcast(String host) {
        this.startLogcatBroadcast(host, 4723);
    }

    default public void startLogcatBroadcast(String host, int port) {
        URI endpointUri;
        this.execute("executeScript", (Map<String, ?>)ImmutableMap.of((Object)"script", (Object)"mobile: startLogsBroadcast", (Object)"args", Collections.emptyList()));
        try {
            endpointUri = new URI(String.format("ws://%s:%s/ws/session/%s/appium/device/logcat", host, port, ((RemoteWebDriver)this).getSessionId()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        logcatClient.connect(endpointUri);
    }

    default public void addLogcatMessagesListener(Consumer<String> handler) {
        logcatClient.addMessageHandler(handler);
    }

    default public void addLogcatErrorsListener(Consumer<Throwable> handler) {
        logcatClient.addErrorHandler(handler);
    }

    default public void addLogcatConnectionListener(Runnable handler) {
        logcatClient.addConnectionHandler(handler);
    }

    default public void addLogcatDisconnectionListener(Runnable handler) {
        logcatClient.addDisconnectionHandler(handler);
    }

    default public void removeAllLogcatListeners() {
        logcatClient.removeAllHandlers();
    }

    default public void stopLogcatBroadcast() {
        this.execute("executeScript", (Map<String, ?>)ImmutableMap.of((Object)"script", (Object)"mobile: stopLogsBroadcast", (Object)"args", Collections.emptyList()));
    }
}

