/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import io.appium.java_client.remote.AppiumW3CHttpCommandCodec;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.W3CHttpCommandCodec;
import org.openqa.selenium.remote.internal.OkHttpClient;
import org.openqa.selenium.remote.service.DriverService;

public class AppiumCommandExecutor
extends HttpCommandExecutor {
    private final Optional<DriverService> serviceOptional;

    private AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        super(additionalCommands, Optional.ofNullable(service).map(DriverService::getUrl).orElse(addressOfRemoteServer), httpClientFactory);
        this.serviceOptional = Optional.ofNullable(service);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, (DriverService)Preconditions.checkNotNull((Object)service), null, httpClientFactory);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, null, (URL)Preconditions.checkNotNull((Object)addressOfRemoteServer), httpClientFactory);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this(additionalCommands, addressOfRemoteServer, (HttpClient.Factory)new OkHttpClient.Factory());
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service) {
        this(additionalCommands, service, (HttpClient.Factory)new OkHttpClient.Factory());
    }

    private <B> B getPrivateFieldValue(String fieldName, Class<B> fieldType) {
        try {
            Field f = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName);
            f.setAccessible(true);
            return fieldType.cast(f.get((Object)this));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private void setPrivateFieldValue(String fieldName, Object newValue) {
        try {
            Field f = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set((Object)this, newValue);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Map<String, CommandInfo> getAdditionalCommands() {
        return this.getPrivateFieldValue("additionalCommands", Map.class);
    }

    private CommandCodec<HttpRequest> getCommandCodec() {
        return this.getPrivateFieldValue("commandCodec", CommandCodec.class);
    }

    private void setCommandCodec(CommandCodec<HttpRequest> newCodec) {
        this.setPrivateFieldValue("commandCodec", newCodec);
    }

    public Response execute(Command command) throws WebDriverException {
        Response response;
        if ("newSession".equals(command.getName())) {
            this.serviceOptional.ifPresent(driverService -> {
                try {
                    driverService.start();
                }
                catch (IOException e) {
                    throw new WebDriverException(e.getMessage(), (Throwable)e);
                }
            });
        }
        try {
            try {
                response = super.execute(command);
            }
            catch (Throwable t) {
                Throwable rootCause = Throwables.getRootCause((Throwable)t);
                if (rootCause instanceof ConnectException && rootCause.getMessage().contains("Connection refused")) {
                    throw this.serviceOptional.map(service -> {
                        if (service.isRunning()) {
                            return new WebDriverException("The session is closed!", rootCause);
                        }
                        return new WebDriverException("The appium server has accidentally died!", rootCause);
                    }).orElseGet((java.util.function.Supplier<WebDriverException>)((Supplier)() -> new WebDriverException(rootCause.getMessage(), rootCause)));
                }
                Throwables.throwIfUnchecked((Throwable)t);
                throw new WebDriverException(t);
            }
        }
        finally {
            if ("quit".equals(command.getName())) {
                this.serviceOptional.ifPresent(DriverService::stop);
            }
        }
        if ("newSession".equals(command.getName()) && this.getCommandCodec() instanceof W3CHttpCommandCodec) {
            this.setCommandCodec((CommandCodec<HttpRequest>)new AppiumW3CHttpCommandCodec());
            this.getAdditionalCommands().forEach((arg_0, arg_1) -> ((AppiumCommandExecutor)this).defineCommand(arg_0, arg_1));
        }
        return response;
    }
}

