/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.touch;

import com.google.common.base.Preconditions;
import io.appium.java_client.touch.offset.AbstractOptionCombinedWithPosition;
import java.util.Map;
import java.util.Optional;

public class TapOptions
extends AbstractOptionCombinedWithPosition<TapOptions> {
    private Integer tapsCount = null;

    public static TapOptions tapOptions() {
        return new TapOptions();
    }

    public TapOptions withTapsCount(int tapsCount) {
        Preconditions.checkArgument((tapsCount > 0 ? 1 : 0) != 0, (Object)"Taps count should be greater than zero");
        this.tapsCount = tapsCount;
        return this;
    }

    @Override
    public Map<String, Object> build() {
        Map<String, Object> result = super.build();
        Optional.ofNullable(this.tapsCount).ifPresent(integer -> result.put("count", integer));
        return result;
    }
}

