/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import io.appium.java_client.remote.AppiumProtocolHandshake;
import io.appium.java_client.remote.AppiumW3CHttpCommandCodec;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpCommandCodec;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.service.DriverService;

public class AppiumCommandExecutor
extends HttpCommandExecutor {
    private static final String IDEMPOTENCY_KEY_HEADER = "X-Idempotency-Key";
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMinutes(10L);
    private final Optional<DriverService> serviceOptional;

    private AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory, ClientConfig clientConfig) {
        super(additionalCommands, Optional.ofNullable(clientConfig).orElse(ClientConfig.defaultConfig().baseUrl((URL)Require.nonNull((String)"Server URL", (Object)Optional.ofNullable(service).map(DriverService::getUrl).orElse(addressOfRemoteServer))).readTimeout(DEFAULT_READ_TIMEOUT)), Optional.ofNullable(httpClientFactory).orElseGet(HttpCommandExecutor::getDefaultClientFactory));
        this.serviceOptional = Optional.ofNullable(service);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, (DriverService)Preconditions.checkNotNull((Object)service), null, httpClientFactory, null);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer, HttpClient.Factory httpClientFactory) {
        this(additionalCommands, null, (URL)Preconditions.checkNotNull((Object)addressOfRemoteServer), httpClientFactory, null);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, ClientConfig clientConfig) {
        this(additionalCommands, null, (URL)Preconditions.checkNotNull((Object)clientConfig.baseUrl()), null, clientConfig);
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, URL addressOfRemoteServer) {
        this(additionalCommands, addressOfRemoteServer, HttpClient.Factory.createDefault());
    }

    public AppiumCommandExecutor(Map<String, CommandInfo> additionalCommands, DriverService service) {
        this(additionalCommands, service, HttpClient.Factory.createDefault());
    }

    protected <B> B getPrivateFieldValue(Class<? extends CommandExecutor> cls, String fieldName, Class<B> fieldType) {
        try {
            Field f = cls.getDeclaredField(fieldName);
            f.setAccessible(true);
            return fieldType.cast(f.get((Object)this));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    protected void setPrivateFieldValue(Class<? extends CommandExecutor> cls, String fieldName, Object newValue) {
        try {
            Field f = cls.getDeclaredField(fieldName);
            f.setAccessible(true);
            f.set((Object)this, newValue);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    protected Map<String, CommandInfo> getAdditionalCommands() {
        return this.getPrivateFieldValue(HttpCommandExecutor.class, "additionalCommands", Map.class);
    }

    protected CommandCodec<HttpRequest> getCommandCodec() {
        return this.getPrivateFieldValue(HttpCommandExecutor.class, "commandCodec", CommandCodec.class);
    }

    protected void setCommandCodec(CommandCodec<HttpRequest> newCodec) {
        this.setPrivateFieldValue(HttpCommandExecutor.class, "commandCodec", newCodec);
    }

    protected void setResponseCodec(ResponseCodec<HttpResponse> codec) {
        this.setPrivateFieldValue(HttpCommandExecutor.class, "responseCodec", codec);
    }

    protected HttpClient getClient() {
        return this.getPrivateFieldValue(HttpCommandExecutor.class, "client", HttpClient.class);
    }

    private Response createSession(Command command) throws IOException {
        if (this.getCommandCodec() != null) {
            throw new SessionNotCreatedException("Session already exists");
        }
        ProtocolHandshake.Result result = new AppiumProtocolHandshake().createSession(this.getClient().with(httpHandler -> req -> {
            req.setHeader(IDEMPOTENCY_KEY_HEADER, UUID.randomUUID().toString().toLowerCase());
            return httpHandler.execute(req);
        }), command);
        Dialect dialect = result.getDialect();
        if (!(dialect.getCommandCodec() instanceof W3CHttpCommandCodec)) {
            throw new SessionNotCreatedException("Only W3C sessions are supported. Please make sure your server is up to date.");
        }
        this.setCommandCodec((CommandCodec<HttpRequest>)new AppiumW3CHttpCommandCodec());
        this.refreshAdditionalCommands();
        this.setResponseCodec((ResponseCodec<HttpResponse>)dialect.getResponseCodec());
        return result.createResponse();
    }

    public void refreshAdditionalCommands() {
        this.getAdditionalCommands().forEach((arg_0, arg_1) -> ((AppiumCommandExecutor)this).defineCommand(arg_0, arg_1));
    }

    public Response execute(Command command) throws WebDriverException {
        if ("newSession".equals(command.getName())) {
            this.serviceOptional.ifPresent(driverService -> {
                try {
                    driverService.start();
                }
                catch (IOException e) {
                    throw new WebDriverException(e.getMessage(), (Throwable)e);
                }
            });
        }
        try {
            Response response = "newSession".equals(command.getName()) ? this.createSession(command) : super.execute(command);
            return response;
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof ConnectException && rootCause.getMessage().contains("Connection refused")) {
                throw this.serviceOptional.map(service -> {
                    if (service.isRunning()) {
                        return new WebDriverException("The session is closed!", rootCause);
                    }
                    return new WebDriverException("The appium server has accidentally died!", rootCause);
                }).orElseGet((java.util.function.Supplier<WebDriverException>)((Supplier)() -> new WebDriverException(rootCause.getMessage(), rootCause)));
            }
            Throwables.throwIfUnchecked((Throwable)t);
            throw new WebDriverException(t);
        }
        finally {
            if ("quit".equals(command.getName())) {
                this.serviceOptional.ifPresent(DriverService::stop);
            }
        }
    }
}

