/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import io.appium.java_client.AppiumClientConfig;
import io.appium.java_client.AppiumExecutionMethod;
import io.appium.java_client.ComparesImages;
import io.appium.java_client.ErrorCodesMobile;
import io.appium.java_client.ExecutesDriverScript;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.HasBrowserCheck;
import io.appium.java_client.HasSettings;
import io.appium.java_client.LogsEvents;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.internal.CapabilityHelpers;
import io.appium.java_client.remote.AppiumCommandExecutor;
import io.appium.java_client.remote.AppiumNewSessionCommandPayload;
import io.appium.java_client.remote.options.BaseOptions;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.service.DriverService;

public class AppiumDriver
extends RemoteWebDriver
implements ExecutesMethod,
ComparesImages,
ExecutesDriverScript,
LogsEvents,
HasBrowserCheck,
HasSettings {
    private static final ErrorHandler errorHandler = new ErrorHandler((ErrorCodes)new ErrorCodesMobile(), true);
    private final URL remoteAddress;
    protected final RemoteLocationContext locationContext;
    private final ExecuteMethod executeMethod = new AppiumExecutionMethod(this);

    public AppiumDriver(HttpCommandExecutor executor, Capabilities capabilities) {
        super((CommandExecutor)executor, capabilities);
        this.locationContext = new RemoteLocationContext(this.executeMethod);
        super.setErrorHandler(errorHandler);
        this.remoteAddress = executor.getAddressOfRemoteServer();
    }

    public AppiumDriver(AppiumClientConfig clientConfig, Capabilities capabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, clientConfig), capabilities);
    }

    public AppiumDriver(URL remoteAddress, Capabilities capabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, remoteAddress), capabilities);
    }

    public AppiumDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities capabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, remoteAddress, httpClientFactory), capabilities);
    }

    public AppiumDriver(AppiumDriverLocalService service, Capabilities capabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, service), capabilities);
    }

    public AppiumDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities capabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, (DriverService)service, httpClientFactory), capabilities);
    }

    public AppiumDriver(AppiumServiceBuilder builder, Capabilities capabilities) {
        this((AppiumDriverLocalService)builder.build(), capabilities);
    }

    public AppiumDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities capabilities) {
        this((AppiumDriverLocalService)builder.build(), httpClientFactory, capabilities);
    }

    public AppiumDriver(HttpClient.Factory httpClientFactory, Capabilities capabilities) {
        this(AppiumDriverLocalService.buildDefaultService(), httpClientFactory, capabilities);
    }

    public AppiumDriver(Capabilities capabilities) {
        this(AppiumDriverLocalService.buildDefaultService(), capabilities);
    }

    protected static Capabilities ensurePlatformName(Capabilities originalCapabilities, String defaultName) {
        return originalCapabilities.getPlatformName() == null ? originalCapabilities.merge((Capabilities)new ImmutableCapabilities("platformName", (Object)defaultName)) : originalCapabilities;
    }

    protected static Capabilities ensureAutomationName(Capabilities originalCapabilities, String defaultName) {
        String currentAutomationName = CapabilityHelpers.getCapability(originalCapabilities, "automationName", String.class);
        if (StringUtils.isBlank((CharSequence)currentAutomationName)) {
            String capabilityName = originalCapabilities.getCapabilityNames().contains("automationName") ? "automationName" : "appium:automationName";
            return originalCapabilities.merge((Capabilities)new ImmutableCapabilities(capabilityName, (Object)defaultName));
        }
        return originalCapabilities;
    }

    protected static Capabilities ensurePlatformAndAutomationNames(Capabilities originalCapabilities, String defaultPlatformName, String defaultAutomationName) {
        Capabilities capsWithPlatformFixed = AppiumDriver.ensurePlatformName(originalCapabilities, defaultPlatformName);
        return AppiumDriver.ensureAutomationName(capsWithPlatformFixed, defaultAutomationName);
    }

    public ExecuteMethod getExecuteMethod() {
        return this.executeMethod;
    }

    public Map<String, Object> getStatus() {
        return (Map)this.execute("status").getValue();
    }

    public void addCommand(HttpMethod httpMethod, String url, String methodName) {
        switch (httpMethod) {
            case GET: {
                MobileCommand.commandRepository.put(methodName, MobileCommand.getC(url));
                break;
            }
            case POST: {
                MobileCommand.commandRepository.put(methodName, MobileCommand.postC(url));
                break;
            }
            case DELETE: {
                MobileCommand.commandRepository.put(methodName, MobileCommand.deleteC(url));
                break;
            }
            default: {
                throw new WebDriverException(String.format("Unsupported HTTP Method: %s. Only %s methods are supported", httpMethod, Arrays.toString(HttpMethod.values())));
            }
        }
        ((AppiumCommandExecutor)this.getCommandExecutor()).refreshAdditionalCommands();
    }

    public URL getRemoteAddress() {
        return this.remoteAddress;
    }

    protected void startSession(Capabilities capabilities) {
        Response response = this.execute(new AppiumNewSessionCommandPayload(capabilities));
        if (response == null) {
            throw new SessionNotCreatedException("The underlying command executor returned a null response.");
        }
        Object responseValue = response.getValue();
        if (responseValue == null) {
            throw new SessionNotCreatedException("The underlying command executor returned a response without payload: " + response);
        }
        if (!(responseValue instanceof Map)) {
            throw new SessionNotCreatedException("The underlying command executor returned a response with a non well formed payload: " + response);
        }
        Map rawCapabilities = (Map)responseValue;
        rawCapabilities.remove("platform");
        if (rawCapabilities.containsKey("browserName") && StringUtils.isBlank((CharSequence)((String)rawCapabilities.get("browserName")))) {
            rawCapabilities.remove("browserName");
        }
        BaseOptions returnedCapabilities = new BaseOptions(rawCapabilities);
        try {
            Field capsField = RemoteWebDriver.class.getDeclaredField("capabilities");
            capsField.setAccessible(true);
            capsField.set(this, returnedCapabilities);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new WebDriverException((Throwable)e);
        }
        this.setSessionId(response.getSessionId());
    }

    @Override
    public Response execute(String driverCommand, Map<String, ?> parameters) {
        return super.execute(driverCommand, parameters);
    }

    @Override
    public Response execute(String command) {
        return super.execute(command, Collections.emptyMap());
    }

    public <X> X getScreenshotAs(final OutputType<X> outputType) {
        return (X)super.getScreenshotAs(new OutputType<X>(){

            public X convertFromBase64Png(String base64Png) {
                String rfc4648Base64 = base64Png.replaceAll("\\r?\\n", "");
                return outputType.convertFromBase64Png(rfc4648Base64);
            }

            public X convertFromPngBytes(byte[] png) {
                return outputType.convertFromPngBytes(png);
            }
        });
    }
}

