/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.clipboard;

import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.clipboard.ClipboardContentType;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;

public interface HasClipboard
extends ExecutesMethod {
    default public void setClipboard(ClipboardContentType contentType, byte[] base64Content) {
        CommandExecutionHelper.execute((ExecutesMethod)this, Map.entry(MobileCommand.SET_CLIPBOARD, Map.of("content", new String(Objects.requireNonNull(base64Content), StandardCharsets.UTF_8), "contentType", contentType.name().toLowerCase())));
    }

    default public String getClipboard(ClipboardContentType contentType) {
        return (String)CommandExecutionHelper.execute((ExecutesMethod)this, Map.entry(MobileCommand.GET_CLIPBOARD, Map.of("contentType", contentType.name().toLowerCase())));
    }

    default public void setClipboardText(String text) {
        this.setClipboard(ClipboardContentType.PLAINTEXT, Base64.getMimeEncoder().encode(text.getBytes(StandardCharsets.UTF_8)));
    }

    default public String getClipboardText() {
        byte[] base64decodedBytes = Base64.getMimeDecoder().decode(this.getClipboard(ClipboardContentType.PLAINTEXT));
        return new String(base64decodedBytes, StandardCharsets.UTF_8);
    }
}

