/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public abstract class AppiumBy
extends By
implements By.Remotable {
    private final By.Remotable.Parameters remoteParameters;
    private final String locatorName;

    protected AppiumBy(String selector, String locatorString, String locatorName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)locatorString) ? 1 : 0) != 0, (Object)"Must supply a not empty locator value.");
        this.remoteParameters = new By.Remotable.Parameters(selector, (Object)locatorString);
        this.locatorName = locatorName;
    }

    public List<WebElement> findElements(SearchContext context) {
        return context.findElements((By)this);
    }

    public WebElement findElement(SearchContext context) {
        return context.findElement((By)this);
    }

    public String toString() {
        return String.format("%s.%s: %s", AppiumBy.class.getSimpleName(), this.locatorName, this.remoteParameters.value());
    }

    public static By accessibilityId(String accessibilityId) {
        return new ByAccessibilityId(accessibilityId);
    }

    public static By androidDataMatcher(String dataMatcherString) {
        return new ByAndroidDataMatcher(dataMatcherString);
    }

    public static By androidUIAutomator(String uiautomatorText) {
        return new ByAndroidUIAutomator(uiautomatorText);
    }

    public static By androidViewMatcher(String viewMatcherString) {
        return new ByAndroidViewMatcher(viewMatcherString);
    }

    public static By androidViewTag(String tag) {
        return new ByAndroidViewTag(tag);
    }

    public static By className(String selector) {
        return new ByClassName(selector);
    }

    public static By id(String selector) {
        return new ById(selector);
    }

    public static By name(String selector) {
        return new ByName(selector);
    }

    public static By custom(String selector) {
        return new ByCustom(selector);
    }

    public static By image(String b64Template) {
        return new ByImage(b64Template);
    }

    public static By iOSClassChain(String iOSClassChainString) {
        return new ByIosClassChain(iOSClassChainString);
    }

    public static By iOSNsPredicateString(String iOSNsPredicateString) {
        return new ByIosNsPredicate(iOSNsPredicateString);
    }

    public static FlutterBy flutterKey(String selector) {
        return new ByFlutterKey(selector);
    }

    public static FlutterBy flutterType(String selector) {
        return new ByFlutterType(selector);
    }

    public static FlutterBy flutterText(String selector) {
        return new ByFlutterText(selector);
    }

    public static FlutterBy flutterTextContaining(String selector) {
        return new ByFlutterTextContaining(selector);
    }

    public static FlutterBy flutterSemanticsLabel(String semanticsLabel) {
        return new ByFlutterSemanticsLabel(semanticsLabel);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppiumBy)) {
            return false;
        }
        AppiumBy other = (AppiumBy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        By.Remotable.Parameters this$remoteParameters = this.getRemoteParameters();
        By.Remotable.Parameters other$remoteParameters = other.getRemoteParameters();
        if (this$remoteParameters == null ? other$remoteParameters != null : !this$remoteParameters.equals(other$remoteParameters)) {
            return false;
        }
        String this$locatorName = this.locatorName;
        String other$locatorName = other.locatorName;
        return !(this$locatorName == null ? other$locatorName != null : !this$locatorName.equals(other$locatorName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AppiumBy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        By.Remotable.Parameters $remoteParameters = this.getRemoteParameters();
        result = result * 59 + ($remoteParameters == null ? 43 : $remoteParameters.hashCode());
        String $locatorName = this.locatorName;
        result = result * 59 + ($locatorName == null ? 43 : $locatorName.hashCode());
        return result;
    }

    @Generated
    public By.Remotable.Parameters getRemoteParameters() {
        return this.remoteParameters;
    }

    public static class ByFlutterTextContaining
    extends FlutterBy
    implements Serializable {
        protected ByFlutterTextContaining(String locatorString) {
            super("-flutter text containing", locatorString, "flutterTextContaining");
        }
    }

    public static class ByFlutterText
    extends FlutterBy
    implements Serializable {
        protected ByFlutterText(String locatorString) {
            super("-flutter text", locatorString, "flutterText");
        }
    }

    public static class ByFlutterSemanticsLabel
    extends FlutterBy
    implements Serializable {
        protected ByFlutterSemanticsLabel(String locatorString) {
            super("-flutter semantics label", locatorString, "flutterSemanticsLabel");
        }
    }

    public static class ByFlutterKey
    extends FlutterBy
    implements Serializable {
        protected ByFlutterKey(String locatorString) {
            super("-flutter key", locatorString, "flutterKey");
        }
    }

    public static class ByFlutterType
    extends FlutterBy
    implements Serializable {
        protected ByFlutterType(String locatorString) {
            super("-flutter type", locatorString, "flutterType");
        }
    }

    public static abstract class FlutterBy
    extends AppiumBy {
        protected FlutterBy(String selector, String locatorString, String locatorName) {
            super(selector, locatorString, locatorName);
        }
    }

    public static class ByIosNsPredicate
    extends AppiumBy
    implements Serializable {
        protected ByIosNsPredicate(String locatorString) {
            super("-ios predicate string", locatorString, "iOSNsPredicate");
        }
    }

    public static class ByIosClassChain
    extends AppiumBy
    implements Serializable {
        protected ByIosClassChain(String locatorString) {
            super("-ios class chain", locatorString, "iOSClassChain");
        }
    }

    public static class ByImage
    extends AppiumBy
    implements Serializable {
        protected ByImage(String b64Template) {
            super("-image", b64Template, "image");
        }
    }

    public static class ByCustom
    extends AppiumBy
    implements Serializable {
        protected ByCustom(String selector) {
            super("-custom", selector, "custom");
        }
    }

    public static class ByClassName
    extends AppiumBy
    implements Serializable {
        protected ByClassName(String selector) {
            super("class name", selector, "className");
        }
    }

    public static class ByName
    extends AppiumBy
    implements Serializable {
        protected ByName(String selector) {
            super("name", selector, "name");
        }
    }

    public static class ById
    extends AppiumBy
    implements Serializable {
        protected ById(String selector) {
            super("id", selector, "id");
        }
    }

    public static class ByAndroidViewTag
    extends AppiumBy
    implements Serializable {
        public ByAndroidViewTag(String tag) {
            super("-android viewtag", tag, "androidViewTag");
        }
    }

    public static class ByAndroidViewMatcher
    extends AppiumBy
    implements Serializable {
        protected ByAndroidViewMatcher(String locatorString) {
            super("-android viewmatcher", locatorString, "androidViewMatcher");
        }
    }

    public static class ByAndroidUIAutomator
    extends AppiumBy
    implements Serializable {
        public ByAndroidUIAutomator(String uiautomatorText) {
            super("-android uiautomator", uiautomatorText, "androidUIAutomator");
        }
    }

    public static class ByAndroidDataMatcher
    extends AppiumBy
    implements Serializable {
        protected ByAndroidDataMatcher(String locatorString) {
            super("-android datamatcher", locatorString, "androidDataMatcher");
        }
    }

    public static class ByAccessibilityId
    extends AppiumBy
    implements Serializable {
        public ByAccessibilityId(String accessibilityId) {
            super("accessibility id", accessibilityId, "accessibilityId");
        }
    }
}

