/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.NoSuchContextException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Response;

public interface SupportsContextSwitching
extends WebDriver,
ExecutesMethod {
    default public WebDriver context(String name) {
        Objects.requireNonNull(name, "Must supply a context name");
        try {
            this.execute("switchToContext", Map.of("name", name));
            return this;
        }
        catch (WebDriverException e) {
            throw new NoSuchContextException(e.getMessage(), e);
        }
    }

    default public Set<String> getContextHandles() {
        Response response = this.execute("getContextHandles", Map.of());
        Object value = response.getValue();
        try {
            List returnedValues = (List)value;
            return new LinkedHashSet<String>(returnedValues);
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + String.valueOf(value), (Throwable)ex);
        }
    }

    default public @Nullable String getContext() {
        String contextName = String.valueOf(this.execute("getCurrentContextHandle").getValue());
        return "null".equalsIgnoreCase(contextName) ? null : contextName;
    }
}

