/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.screenrecording;

import io.appium.java_client.screenrecording.BaseScreenRecordingOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class BaseStartScreenRecordingOptions<T extends BaseStartScreenRecordingOptions<T>>
extends BaseScreenRecordingOptions<BaseStartScreenRecordingOptions<T>> {
    private Boolean forceRestart;
    private Duration timeLimit;

    public T withTimeLimit(Duration timeLimit) {
        this.timeLimit = Objects.requireNonNull(timeLimit);
        return (T)this;
    }

    public T enableForcedRestart() {
        this.forceRestart = true;
        return (T)this;
    }

    public T disableForcedRestart() {
        this.forceRestart = false;
        return (T)this;
    }

    @Override
    public Map<String, Object> build() {
        HashMap<String, Object> map = new HashMap<String, Object>(super.build());
        Optional.ofNullable(this.timeLimit).map(x -> map.put("timeLimit", x.getSeconds()));
        Optional.ofNullable(this.forceRestart).map(x -> map.put("forceRestart", x));
        return Collections.unmodifiableMap(map);
    }
}

