/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.networktasks.internal;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.appmetrica.analytics.coreapi.internal.device.ScreenInfo;
import io.appmetrica.analytics.coreapi.internal.identifiers.AdvertisingIdsHolder;
import io.appmetrica.analytics.coreapi.internal.identifiers.AppSetId;
import io.appmetrica.analytics.coreapi.internal.identifiers.Identifiers;
import io.appmetrica.analytics.coreutils.internal.WrapUtils;
import io.appmetrica.analytics.coreutils.internal.collection.CollectionUtils;
import io.appmetrica.analytics.coreutils.internal.parsing.ParseUtils;
import io.appmetrica.analytics.coreutils.internal.services.FrameworkDetector;
import io.appmetrica.analytics.coreutils.internal.services.PackageManagerUtils;
import io.appmetrica.analytics.coreutils.internal.system.ConstantDeviceInfo;
import io.appmetrica.analytics.networktasks.internal.ArgumentsMerger;
import io.appmetrica.analytics.networktasks.internal.NetworkAppContext;
import io.appmetrica.analytics.networktasks.internal.NetworkServiceLocator;
import io.appmetrica.analytics.networktasks.internal.RetryPolicyConfig;
import io.appmetrica.analytics.networktasks.internal.SdkInfo;
import java.util.List;

public class BaseRequestConfig {
    private String a;
    private ConstantDeviceInfo b;
    private ScreenInfo c;
    private final String d;
    private final String e;
    private final String f;
    private final String g;
    private String h;
    private String i;
    private AppSetId j;
    private AdvertisingIdsHolder k;
    private String l;
    private String m;
    private Identifiers n;
    private RetryPolicyConfig o;

    protected BaseRequestConfig() {
        SdkInfo sdkInfo = NetworkServiceLocator.getInstance().getNetworkAppContext().getSdkInfo();
        v0.d = sdkInfo.getSdkVersionName();
        v0.e = sdkInfo.getSdkBuildNumber();
        v0.f = sdkInfo.getSdkBuildType();
        v0.g = FrameworkDetector.framework();
    }

    public String toString() {
        return "BaseRequestConfig{mPackageName='" + this.a + "', mConstantDeviceInfo=" + this.b + ", screenInfo=" + this.c + ", mSdkVersionName='" + this.d + "', mSdkBuildNumber='" + this.e + "', mSdkBuildType='" + this.f + "', mAppPlatform='android', mProtocolVersion='2', mAppFramework='" + this.g + "', mAppVersion='" + this.h + "', mAppBuildNumber='" + this.i + "', appSetId=" + this.j + ", mAdvertisingIdsHolder=" + this.k + ", mDeviceType='" + this.l + "', mLocale='" + this.m + "', identifiers=" + this.n + ", retryPolicyConfig=" + this.o + '}';
    }

    public String getPackageName() {
        return this.a;
    }

    protected void setPackageName(String string) {
        this.a = string;
    }

    public RetryPolicyConfig getRetryPolicyConfig() {
        return this.o;
    }

    public synchronized boolean isIdentifiersValid() {
        String string;
        Object object = ((BaseRequestConfig)object).n;
        return object != null && (string = object.getUuid()) != null && string.length() != 0 && (string = object.getDeviceId()) != null && string.length() != 0 && (object = object.getDeviceIdHash()) != null && ((String)object).length() != 0;
    }

    protected void setConstantDeviceInfo(ConstantDeviceInfo constantDeviceInfo) {
        this.b = constantDeviceInfo;
    }

    protected void setScreenInfo(@NonNull ScreenInfo screenInfo) {
        this.c = screenInfo;
    }

    protected void setRetryPolicyConfig(RetryPolicyConfig retryPolicyConfig) {
        this.o = retryPolicyConfig;
    }

    protected void setIdentifiers(@Nullable Identifiers identifiers) {
        this.n = identifiers;
    }

    @NonNull
    public String getManufacturer() {
        return (String)WrapUtils.getOrDefault((Object)this.b.manufacturer, (Object)"");
    }

    public String getProtocolVersion() {
        return "2";
    }

    public String getAnalyticsSdkVersionName() {
        return this.d;
    }

    public String getKitBuildNumber() {
        return this.e;
    }

    @NonNull
    public String getKitBuildType() {
        return this.f;
    }

    public String getAppPlatform() {
        return "android";
    }

    @NonNull
    public String getModel() {
        return this.b.model;
    }

    @NonNull
    public String getOsVersion() {
        return this.b.osVersion;
    }

    public int getOsApiLevel() {
        return this.b.osApiLevel;
    }

    protected void setAppBuildNumber(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.i = string;
        }
    }

    public String getAppBuildNumber() {
        return (String)WrapUtils.getOrDefault((Object)this.i, (Object)"");
    }

    public int getAppBuildNumberInt() {
        return ParseUtils.parseIntOrZero((String)this.i);
    }

    public String getAppVersion() {
        return (String)WrapUtils.getOrDefault((Object)this.h, (Object)"");
    }

    protected void setAppVersion(@Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.h = string;
        }
    }

    @NonNull
    public synchronized String getDeviceId() {
        BaseRequestConfig baseRequestConfig = baseRequestConfig.n;
        return (String)WrapUtils.getOrDefault((Object)(baseRequestConfig == null ? null : baseRequestConfig.getDeviceId()), (Object)"");
    }

    @NonNull
    public synchronized String getAppSetId() {
        BaseRequestConfig baseRequestConfig = baseRequestConfig.j;
        return (String)WrapUtils.getOrDefault((Object)(baseRequestConfig == null ? null : baseRequestConfig.getId()), (Object)"");
    }

    @NonNull
    public synchronized String getAppSetIdScope() {
        BaseRequestConfig baseRequestConfig = baseRequestConfig.j;
        return (String)WrapUtils.getOrDefault((Object)(baseRequestConfig == null ? null : baseRequestConfig.getScope().getValue()), (Object)"");
    }

    public synchronized void setAppSetId(@NonNull AppSetId appSetId) {
        this.j = appSetId;
    }

    @NonNull
    public synchronized String getUuid() {
        BaseRequestConfig baseRequestConfig = baseRequestConfig.n;
        return (String)WrapUtils.getOrDefault((Object)(baseRequestConfig == null ? null : baseRequestConfig.getUuid()), (Object)"");
    }

    @NonNull
    public synchronized String getDeviceIDHash() {
        BaseRequestConfig baseRequestConfig = baseRequestConfig.n;
        return (String)WrapUtils.getOrDefault((Object)(baseRequestConfig == null ? null : baseRequestConfig.getDeviceIdHash()), (Object)"");
    }

    @NonNull
    public String getDeviceRootStatus() {
        return this.b.deviceRootStatus;
    }

    @NonNull
    public String getAppFramework() {
        return this.g;
    }

    public int getScreenWidth() {
        return this.c.getWidth();
    }

    public int getScreenHeight() {
        return this.c.getHeight();
    }

    public int getScreenDpi() {
        return this.c.getDpi();
    }

    public float getScaleFactor() {
        return this.c.getScaleFactor();
    }

    @NonNull
    public String getLocale() {
        return (String)WrapUtils.getOrDefault((Object)this.m, (Object)"");
    }

    protected final void setLocale(String string) {
        this.m = string;
    }

    @NonNull
    public String getDeviceType() {
        return (String)WrapUtils.getOrDefault((Object)this.l, (Object)"phone");
    }

    protected void setDeviceType(@Nullable String string) {
        this.l = string;
    }

    @NonNull
    public AdvertisingIdsHolder getAdvertisingIdsHolder() {
        return this.k;
    }

    protected void setAdvertisingIdsHolder(@NonNull AdvertisingIdsHolder advertisingIdsHolder) {
        this.k = advertisingIdsHolder;
    }

    public static abstract class ComponentLoader<T extends BaseRequestConfig, A extends BaseRequestArguments, D extends DataSource<A>>
    implements RequestConfigLoader<T, D> {
        final Context a;
        final String b;

        protected ComponentLoader(@NonNull Context context, @NonNull String string) {
            this.a = context;
            this.b = string;
        }

        @NonNull
        protected abstract T createBlankConfig();

        @Override
        @NonNull
        public T load(@NonNull D object) {
            T t;
            T t2 = t = this.createBlankConfig();
            NetworkAppContext networkAppContext = NetworkServiceLocator.getInstance().getNetworkAppContext();
            Object object2 = networkAppContext.getScreenInfoProvider().getScreenInfo();
            ((BaseRequestConfig)t2).setConstantDeviceInfo(ConstantDeviceInfo.getInstance());
            ((BaseRequestConfig)t2).setScreenInfo((ScreenInfo)object2);
            ((BaseRequestConfig)t).setIdentifiers(((DataSource)object).identifiers);
            String string = ((BaseRequestArguments)((DataSource)object).componentArguments).deviceType;
            if (string == null) {
                string = object2.getDeviceType();
            }
            ((BaseRequestConfig)t).setDeviceType(string);
            object2 = ((BaseRequestArguments)((DataSource)object).componentArguments).appVersion;
            string = this.a;
            if (TextUtils.isEmpty((CharSequence)object2)) {
                object2 = PackageManagerUtils.getAppVersionName((Context)string);
            }
            ((BaseRequestConfig)t).setAppVersion((String)object2);
            object = ((BaseRequestArguments)((DataSource)object).componentArguments).appBuildNumber;
            object2 = this.a;
            if (TextUtils.isEmpty(object)) {
                object = PackageManagerUtils.getAppVersionCodeString((Context)object2);
            }
            T t3 = t;
            ((BaseRequestConfig)t).setAppBuildNumber((String)object);
            ((BaseRequestConfig)t).setPackageName(this.b);
            ((BaseRequestConfig)t).setAdvertisingIdsHolder(networkAppContext.getAdvertisingIdGetter().getIdentifiers(this.a));
            ((BaseRequestConfig)t).setAppSetId(networkAppContext.getAppSetIdProvider().getAppSetId());
            ((BaseRequestConfig)t3).setLocale((String)CollectionUtils.getFirstOrNull((List)networkAppContext.getLocaleProvider().getLocales()));
            return t3;
        }

        @NonNull
        public Context getContext() {
            return this.a;
        }

        @NonNull
        public String getPackageName() {
            return this.b;
        }
    }

    public static abstract class BaseRequestArguments<I, O>
    implements ArgumentsMerger<I, O> {
        @Nullable
        public final String deviceType;
        @Nullable
        public final String appVersion;
        @Nullable
        public final String appBuildNumber;

        public BaseRequestArguments(@Nullable String string, @Nullable String string2, @Nullable String string3) {
            this.deviceType = string;
            this.appVersion = string2;
            this.appBuildNumber = string3;
        }
    }

    public static class DataSource<A> {
        @NonNull
        public final Identifiers identifiers;
        @NonNull
        public final A componentArguments;

        public DataSource(@NonNull Identifiers identifiers, A a2) {
            this.identifiers = identifiers;
            this.componentArguments = a2;
        }
    }

    public static interface RequestConfigLoader<T extends BaseRequestConfig, D> {
        @NonNull
        public T load(D var1);
    }
}

