/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.protobuf.nano;

import io.appmetrica.analytics.protobuf.nano.InternalNano;
import io.appmetrica.analytics.protobuf.nano.InvalidProtocolBufferNanoException;
import io.appmetrica.analytics.protobuf.nano.MessageNano;
import io.appmetrica.analytics.protobuf.nano.WireFormatNano;
import java.io.IOException;

public final class CodedInputByteBufferNano {
    private static final int DEFAULT_RECURSION_LIMIT = 64;
    private static final int DEFAULT_SIZE_LIMIT = 0x4000000;
    private final byte[] buffer;
    private int bufferStart;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int bufferPos;
    private int lastTag;
    private int currentLimit = Integer.MAX_VALUE;
    private int recursionDepth;
    private int recursionLimit = 64;
    private int sizeLimit = 0x4000000;

    public static CodedInputByteBufferNano newInstance(byte[] byArray) {
        return CodedInputByteBufferNano.newInstance(byArray, 0, byArray.length);
    }

    public static CodedInputByteBufferNano newInstance(byte[] byArray, int n, int n2) {
        return new CodedInputByteBufferNano(byArray, n, n2);
    }

    public static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static long decodeZigZag64(long l) {
        return l >>> 1 ^ -(l & 1L);
    }

    private CodedInputByteBufferNano(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.bufferStart = n;
        this.bufferSize = n + n2;
        this.bufferPos = n;
    }

    private void recomputeBufferSizeAfterLimit() {
        int n;
        this.bufferSize = n = this.bufferSize + this.bufferSizeAfterLimit;
        int n2 = this.currentLimit;
        if (n > n2) {
            int n3;
            this.bufferSizeAfterLimit = n3 = n - n2;
            this.bufferSize = n - n3;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    public int readTag() throws IOException {
        int n;
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = n = this.readRawVarint32();
        if (n != 0) {
            return n;
        }
        throw InvalidProtocolBufferNanoException.invalidTag();
    }

    public void checkLastTagWas(int n) throws InvalidProtocolBufferNanoException {
        if (this.lastTag == n) {
            return;
        }
        throw InvalidProtocolBufferNanoException.invalidEndTag();
    }

    public boolean skipField(int n) throws IOException {
        switch (WireFormatNano.getTagWireType(n)) {
            default: {
                throw InvalidProtocolBufferNanoException.invalidWireType();
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
            case 4: {
                return false;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormatNano.makeTag(WireFormatNano.getTagFieldNumber(n), 4));
                return true;
            }
            case 2: {
                CodedInputByteBufferNano codedInputByteBufferNano = this;
                codedInputByteBufferNano.skipRawBytes(codedInputByteBufferNano.readRawVarint32());
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 0: 
        }
        this.readInt32();
        return true;
    }

    public void skipMessage() throws IOException {
        int n;
        while ((n = this.readTag()) != 0 && this.skipField(n)) {
        }
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() throws IOException {
        return this.readRawVarint64();
    }

    public long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    public int readInt32() throws IOException {
        return this.readRawVarint32();
    }

    public long readFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public boolean readBool() throws IOException {
        return this.readRawVarint32() != 0;
    }

    public String readString() throws IOException {
        int n;
        int n2 = this.readRawVarint32();
        if (n2 <= this.bufferSize - (n = this.bufferPos) && n2 > 0) {
            String string;
            String string2 = string;
            string2(this.buffer, n, n2, InternalNano.UTF_8);
            this.bufferPos += n2;
            return string;
        }
        return new String(this.readRawBytes(n2), InternalNano.UTF_8);
    }

    public void readGroup(MessageNano messageNano, int n) throws IOException {
        int n2 = this.recursionDepth;
        if (n2 < this.recursionLimit) {
            CodedInputByteBufferNano codedInputByteBufferNano = this;
            this.recursionDepth = n2 + 1;
            messageNano.mergeFrom(this);
            codedInputByteBufferNano.checkLastTagWas(WireFormatNano.makeTag(n, 4));
            --codedInputByteBufferNano.recursionDepth;
            return;
        }
        throw InvalidProtocolBufferNanoException.recursionLimitExceeded();
    }

    public void readMessage(MessageNano messageNano) throws IOException {
        CodedInputByteBufferNano codedInputByteBufferNano = this;
        int n = codedInputByteBufferNano.readRawVarint32();
        if (codedInputByteBufferNano.recursionDepth < this.recursionLimit) {
            CodedInputByteBufferNano codedInputByteBufferNano2 = this;
            CodedInputByteBufferNano codedInputByteBufferNano3 = this;
            int n2 = codedInputByteBufferNano3.pushLimit(n);
            ++codedInputByteBufferNano3.recursionDepth;
            messageNano.mergeFrom(codedInputByteBufferNano3);
            codedInputByteBufferNano2.checkLastTagWas(0);
            --codedInputByteBufferNano2.recursionDepth;
            codedInputByteBufferNano2.popLimit(n2);
            return;
        }
        throw InvalidProtocolBufferNanoException.recursionLimitExceeded();
    }

    public byte[] readBytes() throws IOException {
        int n;
        int n2 = this.readRawVarint32();
        if (n2 <= this.bufferSize - (n = this.bufferPos) && n2 > 0) {
            byte[] byArray = new byte[n2];
            CodedInputByteBufferNano codedInputByteBufferNano = this;
            System.arraycopy(codedInputByteBufferNano.buffer, n, byArray, 0, n2);
            codedInputByteBufferNano.bufferPos += n2;
            return byArray;
        }
        if (n2 == 0) {
            return WireFormatNano.EMPTY_BYTES;
        }
        return this.readRawBytes(n2);
    }

    public int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    public int readEnum() throws IOException {
        return this.readRawVarint32();
    }

    public int readSFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public long readSFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public int readSInt32() throws IOException {
        return CodedInputByteBufferNano.decodeZigZag32(this.readRawVarint32());
    }

    public long readSInt64() throws IOException {
        return CodedInputByteBufferNano.decodeZigZag64(this.readRawVarint64());
    }

    public int readRawVarint32() throws IOException {
        int n;
        int n2 = this.readRawByte();
        if (n2 >= 0) {
            return n2;
        }
        n2 &= 0x7F;
        int n3 = this.readRawByte();
        if (n3 >= 0) {
            n = n2 | n3 << 7;
        } else {
            n2 |= (n3 & 0x7F) << 7;
            n3 = this.readRawByte();
            if (n3 >= 0) {
                n = n2 | n3 << 14;
            } else {
                n2 |= (n3 & 0x7F) << 14;
                n3 = this.readRawByte();
                if (n3 >= 0) {
                    n = n2 | n3 << 21;
                } else {
                    n2 |= (n3 & 0x7F) << 21;
                    byte by = this.readRawByte();
                    n2 |= by << 28;
                    if (by < 0) {
                        for (n3 = 0; n3 < 5; ++n3) {
                            if (this.readRawByte() < 0) continue;
                            return n2;
                        }
                        throw InvalidProtocolBufferNanoException.malformedVarint();
                    }
                    n = n2;
                }
            }
        }
        return n;
    }

    public long readRawVarint64() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.readRawByte();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw InvalidProtocolBufferNanoException.malformedVarint();
    }

    public int readRawLittleEndian32() throws IOException {
        CodedInputByteBufferNano codedInputByteBufferNano = this;
        byte by = codedInputByteBufferNano.readRawByte();
        byte by2 = codedInputByteBufferNano.readRawByte();
        byte by3 = codedInputByteBufferNano.readRawByte();
        return this.readRawByte() & 0xFF | (by & 0xFF) << 8 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 24;
    }

    public long readRawLittleEndian64() throws IOException {
        CodedInputByteBufferNano codedInputByteBufferNano = this;
        byte by = codedInputByteBufferNano.readRawByte();
        byte by2 = codedInputByteBufferNano.readRawByte();
        byte by3 = codedInputByteBufferNano.readRawByte();
        byte by4 = codedInputByteBufferNano.readRawByte();
        byte by5 = codedInputByteBufferNano.readRawByte();
        byte by6 = codedInputByteBufferNano.readRawByte();
        byte by7 = codedInputByteBufferNano.readRawByte();
        byte by8 = codedInputByteBufferNano.readRawByte();
        return (long)by & 0xFFL | ((long)by2 & 0xFFL) << 8 | ((long)by3 & 0xFFL) << 16 | ((long)by4 & 0xFFL) << 24 | ((long)by5 & 0xFFL) << 32 | ((long)by6 & 0xFFL) << 40 | ((long)by7 & 0xFFL) << 48 | ((long)by8 & 0xFFL) << 56;
    }

    public int setRecursionLimit(int n) {
        if (n >= 0) {
            this.recursionLimit = n;
            return this.recursionLimit;
        }
        throw new IllegalArgumentException("Recursion limit cannot be negative: " + n);
    }

    public int setSizeLimit(int n) {
        if (n >= 0) {
            this.sizeLimit = n;
            return this.sizeLimit;
        }
        throw new IllegalArgumentException("Size limit cannot be negative: " + n);
    }

    public void resetSizeCounter() {
    }

    public int pushLimit(int n) throws InvalidProtocolBufferNanoException {
        if (n >= 0) {
            int n2 = this.currentLimit;
            if ((n += this.bufferPos) <= n2) {
                this.currentLimit = n;
                this.recomputeBufferSizeAfterLimit();
                return n2;
            }
            throw InvalidProtocolBufferNanoException.truncatedMessage();
        }
        throw InvalidProtocolBufferNanoException.negativeSize();
    }

    public void popLimit(int n) {
        this.currentLimit = n;
        this.recomputeBufferSizeAfterLimit();
    }

    public int getBytesUntilLimit() {
        int n = this.currentLimit;
        if (n == Integer.MAX_VALUE) {
            return -1;
        }
        return n - this.bufferPos;
    }

    public boolean isAtEnd() {
        return this.bufferPos == this.bufferSize;
    }

    public int getPosition() {
        return this.bufferPos - this.bufferStart;
    }

    public byte[] getData(int n, int n2) {
        if (n2 == 0) {
            return WireFormatNano.EMPTY_BYTES;
        }
        byte[] byArray = new byte[n2];
        CodedInputByteBufferNano codedInputByteBufferNano = this;
        int n3 = codedInputByteBufferNano.bufferStart + n;
        System.arraycopy(codedInputByteBufferNano.buffer, n3, byArray, 0, n2);
        return byArray;
    }

    public void rewindToPosition(int n) {
        int n2 = this.bufferStart;
        if (n <= this.bufferPos - n2) {
            if (n >= 0) {
                this.bufferPos = n2 + n;
                return;
            }
            throw new IllegalArgumentException("Bad position " + n);
        }
        throw new IllegalArgumentException("Position " + n + " is beyond current " + (this.bufferPos - this.bufferStart));
    }

    public byte readRawByte() throws IOException {
        int n = this.bufferPos;
        if (n != this.bufferSize) {
            this.bufferPos = n + 1;
            return this.buffer[n];
        }
        throw InvalidProtocolBufferNanoException.truncatedMessage();
    }

    public byte[] readRawBytes(int n) throws IOException {
        if (n >= 0) {
            int n2 = this.bufferPos;
            int n3 = this.currentLimit;
            if (n2 + n <= n3) {
                if (n <= this.bufferSize - n2) {
                    byte[] byArray = new byte[n];
                    CodedInputByteBufferNano codedInputByteBufferNano = this;
                    System.arraycopy(codedInputByteBufferNano.buffer, n2, byArray, 0, n);
                    codedInputByteBufferNano.bufferPos += n;
                    return byArray;
                }
                throw InvalidProtocolBufferNanoException.truncatedMessage();
            }
            this.skipRawBytes(n3 - n2);
            throw InvalidProtocolBufferNanoException.truncatedMessage();
        }
        throw InvalidProtocolBufferNanoException.negativeSize();
    }

    public void skipRawBytes(int n) throws IOException {
        if (n >= 0) {
            int n2 = this.bufferPos;
            int n3 = this.currentLimit;
            if (n2 + n <= n3) {
                if (n <= this.bufferSize - n2) {
                    this.bufferPos = n2 + n;
                    return;
                }
                throw InvalidProtocolBufferNanoException.truncatedMessage();
            }
            this.skipRawBytes(n3 - n2);
            throw InvalidProtocolBufferNanoException.truncatedMessage();
        }
        throw InvalidProtocolBufferNanoException.negativeSize();
    }

    Object readPrimitiveField(int n) throws IOException {
        switch (n) {
            default: {
                throw new IllegalArgumentException("Unknown type " + n);
            }
            case 18: {
                return this.readSInt64();
            }
            case 17: {
                return this.readSInt32();
            }
            case 16: {
                return this.readSFixed64();
            }
            case 15: {
                return this.readSFixed32();
            }
            case 14: {
                return this.readEnum();
            }
            case 13: {
                return this.readUInt32();
            }
            case 12: {
                return this.readBytes();
            }
            case 9: {
                return this.readString();
            }
            case 8: {
                return this.readBool();
            }
            case 7: {
                return this.readFixed32();
            }
            case 6: {
                return this.readFixed64();
            }
            case 5: {
                return this.readInt32();
            }
            case 4: {
                return this.readUInt64();
            }
            case 3: {
                return this.readInt64();
            }
            case 2: {
                return Float.valueOf(this.readFloat());
            }
            case 1: 
        }
        return this.readDouble();
    }
}

