/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0004\u0017\u0018\u0019\u001aB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/appmetrica/analytics/gradle/common/VersionNumber;", "", "major", "", "minor", "micro", "patch", "scheme", "Lio/appmetrica/analytics/gradle/common/VersionNumber$AbstractScheme;", "(IIIILio/appmetrica/analytics/gradle/common/VersionNumber$AbstractScheme;)V", "getMajor", "()I", "getMicro", "getMinor", "getPatch", "compareTo", "other", "equals", "", "", "hashCode", "toString", "", "AbstractScheme", "Companion", "DefaultScheme", "Scheme", "common"})
public final class VersionNumber
implements Comparable<VersionNumber> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int micro;
    private final int patch;
    @NotNull
    private final AbstractScheme scheme;
    @NotNull
    private static final DefaultScheme DEFAULT_SCHEME = new DefaultScheme();
    @NotNull
    private static final VersionNumber UNKNOWN = io.appmetrica.analytics.gradle.common.VersionNumber$Companion.version$default(Companion, 0, 0, 2, null);

    private VersionNumber(int major, int minor, int micro, int patch, AbstractScheme scheme) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.patch = patch;
        this.scheme = scheme;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getMicro() {
        return this.micro;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Override
    public int compareTo(@NotNull VersionNumber other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.major != other.major ? this.major - other.major : (this.minor != other.minor ? this.minor - other.minor : (this.micro != other.micro ? this.micro - other.micro : this.patch - other.patch));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof VersionNumber && this.compareTo((VersionNumber)other) == 0;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.micro;
        result = 31 * result + this.patch;
        return result;
    }

    @NotNull
    public String toString() {
        return this.scheme.format(this);
    }

    public /* synthetic */ VersionNumber(int major, int minor, int micro, int patch, AbstractScheme scheme, DefaultConstructorMarker $constructor_marker) {
        this(major, minor, micro, patch, scheme);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lio/appmetrica/analytics/gradle/common/VersionNumber$DefaultScheme;", "Lio/appmetrica/analytics/gradle/common/VersionNumber$AbstractScheme;", "()V", "format", "", "versionNumber", "Lio/appmetrica/analytics/gradle/common/VersionNumber;", "Companion", "common"})
    private static final class DefaultScheme
    extends AbstractScheme {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final String VERSION_TEMPLATE = "%d.%d.%d";

        public DefaultScheme() {
            super(3);
        }

        @Override
        @NotNull
        public String format(@NotNull VersionNumber versionNumber) {
            Intrinsics.checkNotNullParameter((Object)versionNumber, (String)"versionNumber");
            String string = VERSION_TEMPLATE;
            Object[] objectArray = new Object[]{versionNumber.getMajor(), versionNumber.getMinor(), versionNumber.getMicro()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            return string2;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/appmetrica/analytics/gradle/common/VersionNumber$DefaultScheme$Companion;", "", "()V", "VERSION_TEMPLATE", "", "common"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001:\u0001\u000bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lio/appmetrica/analytics/gradle/common/VersionNumber$AbstractScheme;", "Lio/appmetrica/analytics/gradle/common/VersionNumber$Scheme;", "depth", "", "(I)V", "getDepth", "()I", "parse", "Lio/appmetrica/analytics/gradle/common/VersionNumber;", "value", "", "Scanner", "common"})
    private static abstract class AbstractScheme
    implements Scheme {
        private final int depth;

        protected AbstractScheme(int depth) {
            this.depth = depth;
        }

        public final int getDepth() {
            return this.depth;
        }

        @Override
        @NotNull
        public VersionNumber parse(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (((CharSequence)value).length() > 0) {
                Scanner scanner = new Scanner(value);
                int minor = 0;
                int micro = 0;
                int patch = 0;
                if (!scanner.hasDigit()) {
                    return UNKNOWN;
                }
                int major = scanner.scanDigit();
                char[] cArray = new char[]{'.'};
                if (scanner.isSeparatorAndDigit(cArray)) {
                    scanner.skipSeparator();
                    minor = scanner.scanDigit();
                    cArray = new char[]{'.'};
                    if (scanner.isSeparatorAndDigit(cArray)) {
                        scanner.skipSeparator();
                        micro = scanner.scanDigit();
                        if (this.depth > 3 && scanner.isSeparatorAndDigit(cArray = new char[]{'.', '_'})) {
                            scanner.skipSeparator();
                            patch = scanner.scanDigit();
                        }
                    }
                }
                if (scanner.isEnd()) {
                    return new VersionNumber(major, minor, micro, patch, this, null);
                }
                if (scanner.isQualifier()) {
                    scanner.skipSeparator();
                    return new VersionNumber(major, minor, micro, patch, this, null);
                }
                return UNKNOWN;
            }
            return UNKNOWN;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0006J\u0012\u0010\u0012\u001a\u00020\u00062\n\u0010\u0013\u001a\u00020\u0014\"\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\u00062\n\u0010\u0013\u001a\u00020\u0014\"\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lio/appmetrica/analytics/gradle/common/VersionNumber$AbstractScheme$Scanner;", "", "str", "", "(Ljava/lang/String;)V", "isEnd", "", "()Z", "isQualifier", "pos", "", "getPos", "()I", "setPos", "(I)V", "getStr", "()Ljava/lang/String;", "hasDigit", "isSeparatorAndDigit", "separators", "", "", "oneOf", "remainder", "scanDigit", "skipSeparator", "", "common"})
        private static final class Scanner {
            @NotNull
            private final String str;
            private int pos;

            public Scanner(@NotNull String str) {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                this.str = str;
            }

            @NotNull
            public final String getStr() {
                return this.str;
            }

            public final int getPos() {
                return this.pos;
            }

            public final void setPos(int n) {
                this.pos = n;
            }

            public final boolean hasDigit() {
                return this.pos < this.str.length() && Character.isDigit(this.str.charAt(this.pos));
            }

            public final boolean isSeparatorAndDigit(char ... separators) {
                Intrinsics.checkNotNullParameter((Object)separators, (String)"separators");
                return this.pos < this.str.length() - 1 && this.oneOf(Arrays.copyOf(separators, separators.length)) && Character.isDigit(this.str.charAt(this.pos + 1));
            }

            private final boolean oneOf(char ... separators) {
                char current = this.str.charAt(this.pos);
                for (char separator2 : separators) {
                    if (current != separator2) continue;
                    return true;
                }
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isQualifier() {
                if (this.pos >= this.str.length() - 1) return false;
                char[] cArray = new char[]{'.', '-'};
                if (!this.oneOf(cArray)) return false;
                return true;
            }

            public final int scanDigit() {
                int start = this.pos;
                while (this.hasDigit()) {
                    ++this.pos;
                }
                String string = this.str.substring(start, this.pos);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                return Integer.parseInt(string);
            }

            public final boolean isEnd() {
                return this.pos == this.str.length();
            }

            public final void skipSeparator() {
                ++this.pos;
            }

            @Nullable
            public final String remainder() {
                String string;
                if (this.pos == this.str.length()) {
                    string = null;
                } else {
                    String string2 = this.str.substring(this.pos);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                }
                return string;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lio/appmetrica/analytics/gradle/common/VersionNumber$Scheme;", "", "format", "", "versionNumber", "Lio/appmetrica/analytics/gradle/common/VersionNumber;", "parse", "value", "common"})
    public static interface Scheme {
        @NotNull
        public VersionNumber parse(@NotNull String var1);

        @NotNull
        public String format(@NotNull VersionNumber var1);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/appmetrica/analytics/gradle/common/VersionNumber$Companion;", "", "()V", "DEFAULT_SCHEME", "Lio/appmetrica/analytics/gradle/common/VersionNumber$DefaultScheme;", "UNKNOWN", "Lio/appmetrica/analytics/gradle/common/VersionNumber;", "parse", "versionString", "", "version", "major", "", "minor", "common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @NotNull
        public final VersionNumber version(int major, int minor) {
            return new VersionNumber(major, minor, 0, 0, DEFAULT_SCHEME, null);
        }

        public static /* synthetic */ VersionNumber version$default(Companion companion, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            return companion.version(n, n2);
        }

        @NotNull
        public final VersionNumber parse(@NotNull String versionString) {
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            return DEFAULT_SCHEME.parse(versionString);
        }

        @JvmOverloads
        @NotNull
        public final VersionNumber version(int major) {
            return io.appmetrica.analytics.gradle.common.VersionNumber$Companion.version$default(this, major, 0, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

