/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.configurator;

import io.appmetrica.analytics.gradle.common.BuildUuidHelper;
import io.appmetrica.analytics.gradle.common.Log;
import io.appmetrica.analytics.gradle.common.api.AndroidApplicationVariant;
import io.appmetrica.analytics.gradle.common.config.AppMetricaPluginConfig;
import io.appmetrica.analytics.gradle.common.configurator.Configurator;
import io.appmetrica.analytics.gradle.common.provider.BuildInfoFileProvider;
import io.appmetrica.analytics.gradle.common.provider.FileProvider;
import io.appmetrica.analytics.gradle.common.provider.MappingFileProvider;
import io.appmetrica.analytics.gradle.common.provider.ZipFileProvider;
import io.appmetrica.analytics.gradle.common.tasks.CheckDependenciesTask;
import io.appmetrica.analytics.gradle.common.tasks.UploadTask;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lio/appmetrica/analytics/gradle/common/configurator/CommonConfigurator;", "Lio/appmetrica/analytics/gradle/common/configurator/Configurator;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configure", "", "variant", "Lio/appmetrica/analytics/gradle/common/api/AndroidApplicationVariant;", "config", "Lio/appmetrica/analytics/gradle/common/config/AppMetricaPluginConfig;", "common"})
public final class CommonConfigurator
extends Configurator {
    public CommonConfigurator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    public void configure(@NotNull AndroidApplicationVariant variant, @NotNull AppMetricaPluginConfig config) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String buildId = BuildUuidHelper.INSTANCE.getBuildUuid(variant);
        Log.INSTANCE.info("Configuring " + variant.getName() + ":\n\tbuild id = " + buildId + "\n\toffline = " + config.getOffline().invoke() + "\n\tndk.enable = " + config.getNdk().getEnable().invoke());
        String it = buildId;
        boolean bl = false;
        variant.resValue("string", "com.yandex.android.appmetrica.build_id", it);
        variant.resValue("string", "io.appmetrica.analytics.build_id", it);
        boolean it2 = (Boolean)config.getOffline().invoke();
        boolean bl2 = false;
        variant.resValue("bool", "com.yandex.android.appmetrica.is_offline", String.valueOf(it2));
        variant.resValue("bool", "io.appmetrica.analytics.is_offline", String.valueOf(it2));
        it2 = (Boolean)config.getNdk().getEnable().invoke();
        boolean bl3 = false;
        variant.resValue("bool", "com.yandex.android.appmetrica.ndk.enable", String.valueOf(it2));
        variant.resValue("bool", "io.appmetrica.analytics.ndk.enable", String.valueOf(it2));
        CheckDependenciesTask checkDependenciesTask = (CheckDependenciesTask)this.getProject().getTasks().create("check" + StringsKt.capitalize((String)variant.getName()) + "AppMetricaDependencies", CheckDependenciesTask.class, arg_0 -> CommonConfigurator.configure$lambda-3(variant, config, arg_0));
        UploadTask uploadTask = (UploadTask)this.getProject().getTasks().create("upload" + StringsKt.capitalize((String)variant.getName()) + "Mapping", UploadTask.class, arg_0 -> CommonConfigurator.configure$lambda-4(config, this, buildId, variant, checkDependenciesTask, arg_0));
        this.getProject().afterEvaluate(arg_0 -> CommonConfigurator.configure$lambda-5(variant, uploadTask, checkDependenciesTask, arg_0));
    }

    private static final void configure$lambda-3(AndroidApplicationVariant $variant, AppMetricaPluginConfig $config, CheckDependenciesTask task) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        task.setVariant($variant);
        task.setAllowTwoAppMetricas((Boolean)$config.getAllowTwoAppMetricas().invoke());
    }

    private static final void configure$lambda-4(AppMetricaPluginConfig $config, CommonConfigurator this$0, String $buildId, AndroidApplicationVariant $variant, CheckDependenciesTask $checkDependenciesTask, UploadTask task) {
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$buildId, (String)"$buildId");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        task.setUploadUrl("https://api.appmetrica.yandex.ru/management/v1/application/crash/proguard/upload");
        task.setPostApiKey((String)$config.getPostApiKey().invoke());
        task.setOffline((Boolean)$config.getOffline().invoke());
        Object[] objectArray = new FileProvider[]{new BuildInfoFileProvider(this$0.getProject(), $buildId, $variant), new MappingFileProvider($variant, $config)};
        List list = CollectionsKt.listOf((Object[])objectArray);
        String[] stringArray = new String[]{"mappings", $variant.getFlavorName(), $variant.getBuildTypeName()};
        File file = Paths.get(this$0.getProject().getBuildDir().getAbsolutePath(), stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(project.buildDir.abs\u2026t.buildTypeName).toFile()");
        task.setFileProvider(new ZipFileProvider(list, file));
        task.setEnableAnalytics($config.getEnableAnalytics());
        task.setParamsForAnalytics(MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"task_type", (Object)"upload_mapping")), this$0.getParamsForAnalytics($variant, $config)));
        objectArray = new Object[]{$checkDependenciesTask};
        task.dependsOn(objectArray);
    }

    private static final void configure$lambda-5(AndroidApplicationVariant $variant, UploadTask $uploadTask, CheckDependenciesTask $checkDependenciesTask, Project it) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullExpressionValue((Object)((Object)$uploadTask), (String)"uploadTask");
        $variant.subscribeOnAssembleTask((Task)$uploadTask);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)$checkDependenciesTask), (String)"checkDependenciesTask");
        $variant.subscribeOnAssembleTask((Task)$checkDependenciesTask);
    }
}

