/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.configurator;

import io.appmetrica.analytics.gradle.common.BuildUuidHelper;
import io.appmetrica.analytics.gradle.common.Log;
import io.appmetrica.analytics.gradle.common.api.AndroidApplicationVariant;
import io.appmetrica.analytics.gradle.common.config.AppMetricaPluginConfig;
import io.appmetrica.analytics.gradle.common.configurator.Configurator;
import io.appmetrica.analytics.gradle.common.provider.BuildInfoFileProvider;
import io.appmetrica.analytics.gradle.common.provider.FileProvider;
import io.appmetrica.analytics.gradle.common.provider.SymbolsFileProvider;
import io.appmetrica.analytics.gradle.common.provider.ZipFileProvider;
import io.appmetrica.analytics.gradle.common.tasks.UploadTask;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lio/appmetrica/analytics/gradle/common/configurator/NdkConfigurator;", "Lio/appmetrica/analytics/gradle/common/configurator/Configurator;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "configure", "", "variant", "Lio/appmetrica/analytics/gradle/common/api/AndroidApplicationVariant;", "config", "Lio/appmetrica/analytics/gradle/common/config/AppMetricaPluginConfig;", "common"})
public final class NdkConfigurator
extends Configurator {
    public NdkConfigurator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    public void configure(@NotNull AndroidApplicationVariant variant, @NotNull AppMetricaPluginConfig config) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Log.INSTANCE.info("Configuring ndk " + variant.getName());
        if (((Boolean)config.getNdk().getAddNdkCrashesDependency().invoke()).booleanValue()) {
            this.getProject().getDependencies().add(variant.getName() + "Implementation", (Object)"io.appmetrica.analytics:analytics-ndk-crashes:3.0.0");
        }
        String buildId = BuildUuidHelper.INSTANCE.getBuildUuid(variant);
        this.getProject().getTasks().create("upload" + StringsKt.capitalize((String)variant.getName()) + "Symbols", UploadTask.class, arg_0 -> NdkConfigurator.configure$lambda-0(config, this, buildId, variant, arg_0));
    }

    private static final void configure$lambda-0(AppMetricaPluginConfig $config, NdkConfigurator this$0, String $buildId, AndroidApplicationVariant $variant, UploadTask task) {
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$buildId, (String)"$buildId");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        task.setUploadUrl("https://api.appmetrica.yandex.ru/management/v1/application/crash/android_native/upload");
        task.setPostApiKey((String)$config.getPostApiKey().invoke());
        task.setOffline((Boolean)$config.getOffline().invoke());
        Object[] objectArray = new FileProvider[]{new BuildInfoFileProvider(this$0.getProject(), $buildId, $variant), new SymbolsFileProvider($config.getNdk())};
        List list = CollectionsKt.listOf((Object[])objectArray);
        String[] stringArray = new String[]{"symbols", $variant.getFlavorName(), $variant.getBuildTypeName()};
        File file = Paths.get(this$0.getProject().getBuildDir().getAbsolutePath(), stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"get(project.buildDir.abs\u2026t.buildTypeName).toFile()");
        task.setFileProvider(new ZipFileProvider(list, file));
        task.setEnableAnalytics($config.getEnableAnalytics());
        task.setParamsForAnalytics(MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"task_type", (Object)"upload_ndk")), this$0.getParamsForAnalytics($variant, $config)));
    }
}

