/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.dwarf;

import io.appmetrica.analytics.gradle.common.Log;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.DwarfException;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.FileContext;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.ReferenceBytesConverter;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.CompilationUnitContext;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.DebugInfoParserKt;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineData;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineStateMachineKt;
import io.appmetrica.analytics.gradle.common.ndk.elf.DebugElfSectionHeaders;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfHandler;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeader;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"parseDebugLineData", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineData;", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "context", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/CompilationUnitContext;", "debugLineSectionHeader", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSectionHeader;", "parseDwarf", "", "handler", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfHandler;", "byteOrder", "Ljava/nio/ByteOrder;", "debugHeaders", "Lio/appmetrica/analytics/gradle/common/ndk/elf/DebugElfSectionHeaders;", "common"})
public final class DwarfParserKt {
    /*
     * WARNING - void declaration
     */
    public static final void parseDwarf(@NotNull ByteReader reader, @NotNull ElfHandler handler, @NotNull ByteOrder byteOrder, @NotNull DebugElfSectionHeaders debugHeaders) throws IOException, DwarfException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        Intrinsics.checkNotNullParameter((Object)debugHeaders, (String)"debugHeaders");
        Log.INSTANCE.debug("Processing debug headers : " + debugHeaders.getHeaderNames());
        FileContext fileContext = new FileContext(debugHeaders, new ReferenceBytesConverter(byteOrder), null, 4, null);
        Log.INSTANCE.debug("Reading compilation unit contexts");
        Iterable iterable = DebugInfoParserKt.parseDebugInfo(reader, fileContext);
        ElfHandler elfHandler = handler;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cuContext;
            CompilationUnitContext compilationUnitContext = (CompilationUnitContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Log.INSTANCE.debug("Reading debug line data for compilation unit " + cuContext.getName());
            collection.add(TuplesKt.to((Object)cuContext, (Object)DwarfParserKt.parseDebugLineData(reader, (CompilationUnitContext)cuContext, debugHeaders.getDebugLine())));
        }
        elfHandler.processDebugInfoCompilationUnit(MapsKt.toMap((Iterable)((List)destination$iv$iv)));
    }

    @NotNull
    public static final DebugLineData parseDebugLineData(@NotNull ByteReader reader, @NotNull CompilationUnitContext context, @NotNull ElfSectionHeader debugLineSectionHeader) throws IOException {
        DebugLineData debugLineData;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)debugLineSectionHeader, (String)"debugLineSectionHeader");
        Long debugLineOffset = context.getDebugLineOffset();
        if (debugLineOffset != null) {
            DebugLineData debugLineData2;
            try {
                reader.seek(debugLineSectionHeader.getOffset() + debugLineOffset);
                debugLineData2 = DebugLineStateMachineKt.parseDebugLinesFromCurrentOffset(reader, context.getHeader().getAddressSize());
            }
            catch (DwarfException e) {
                Log.INSTANCE.debug("Could not parse debug line data : " + e);
                debugLineData2 = new DebugLineData(null, null, 3, null);
            }
            debugLineData = debugLineData2;
        } else {
            Log.INSTANCE.debug("Could not parse debug line data : debug line offset is null");
            debugLineData = new DebugLineData(null, null, 3, null);
        }
        return debugLineData;
    }
}

