/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.dwarf;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/appmetrica/analytics/gradle/common/ndk/dwarf/ReferenceBytesConverter;", "", "byteOrder", "Ljava/nio/ByteOrder;", "(Ljava/nio/ByteOrder;)V", "asLongValue", "", "data", "", "common"})
public final class ReferenceBytesConverter {
    @NotNull
    private final ByteOrder byteOrder;

    public ReferenceBytesConverter(@NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
        this.byteOrder = byteOrder;
    }

    public final long asLongValue(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] padded = new byte[8];
        int dest = Intrinsics.areEqual((Object)this.byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? 8 - data.length : 0;
        System.arraycopy(data, 0, padded, dest, data.length);
        return ByteBuffer.wrap(padded).order(this.byteOrder).getLong();
    }
}

