/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.reader;

import io.appmetrica.analytics.gradle.common.ndk.dwarf.ReferenceBytesConverter;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.abbrev.DWForm;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.abbrev.DebugAbbrevAttribute;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.CompilationUnitHeader;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.processor.AttributeProcessor;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.reader.AttributesReader;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.attribute.reader.DebugAttributesReaderKt;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001b\u0010\u0012\u001a\u00028\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/attribute/reader/DebugAttributesReader;", "T", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/attribute/reader/AttributesReader;", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "cuHeader", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/CompilationUnitHeader;", "referenceBytesConverter", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/ReferenceBytesConverter;", "attributeProcessor", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/attribute/processor/AttributeProcessor;", "debugStrOffset", "", "(Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/CompilationUnitHeader;Lio/appmetrica/analytics/gradle/common/ndk/dwarf/ReferenceBytesConverter;Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/attribute/processor/AttributeProcessor;J)V", "processDebugInfoEntryAttribute", "", "attribute", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/abbrev/DebugAbbrevAttribute;", "readAttributes", "attributes", "", "(Ljava/util/List;)Ljava/lang/Object;", "common"})
public final class DebugAttributesReader<T>
implements AttributesReader<T> {
    @NotNull
    private final ByteReader reader;
    @NotNull
    private final CompilationUnitHeader cuHeader;
    @NotNull
    private final ReferenceBytesConverter referenceBytesConverter;
    @NotNull
    private final AttributeProcessor<T> attributeProcessor;
    private final long debugStrOffset;

    public DebugAttributesReader(@NotNull ByteReader reader, @NotNull CompilationUnitHeader cuHeader, @NotNull ReferenceBytesConverter referenceBytesConverter, @NotNull AttributeProcessor<T> attributeProcessor, long debugStrOffset) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)cuHeader, (String)"cuHeader");
        Intrinsics.checkNotNullParameter((Object)referenceBytesConverter, (String)"referenceBytesConverter");
        Intrinsics.checkNotNullParameter(attributeProcessor, (String)"attributeProcessor");
        this.reader = reader;
        this.cuHeader = cuHeader;
        this.referenceBytesConverter = referenceBytesConverter;
        this.attributeProcessor = attributeProcessor;
        this.debugStrOffset = debugStrOffset;
    }

    @Override
    public T readAttributes(@NotNull List<DebugAbbrevAttribute> attributes) throws IOException {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Iterable $this$forEach$iv = attributes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DebugAbbrevAttribute it = (DebugAbbrevAttribute)element$iv;
            boolean bl = false;
            this.processDebugInfoEntryAttribute(it);
        }
        return this.attributeProcessor.finishProcessingAttributes();
    }

    private final void processDebugInfoEntryAttribute(DebugAbbrevAttribute attribute) throws IOException {
        switch (WhenMappings.$EnumSwitchMapping$0[attribute.getForm().ordinal()]) {
            case 1: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readLong(this.cuHeader.getAddressSize()));
                break;
            }
            case 2: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytesWithBlockSize());
                break;
            }
            case 3: {
                byte[] bytes = this.reader.readBytesWithBlockSize(1);
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), bytes);
                break;
            }
            case 4: {
                byte[] bytes = this.reader.readBytesWithBlockSize(2);
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), bytes);
                break;
            }
            case 5: {
                byte[] bytes = this.reader.readBytesWithBlockSize(4);
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), bytes);
                break;
            }
            case 6: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytes(1));
                break;
            }
            case 7: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytes(2));
                break;
            }
            case 8: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytes(4));
                break;
            }
            case 9: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytes(8));
                break;
            }
            case 10: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readSLEB128());
                break;
            }
            case 11: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readULEB128());
                break;
            }
            case 12: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readNullTerminatedString(Charsets.UTF_8));
                break;
            }
            case 13: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readLong(1));
                break;
            }
            case 14: {
                this.attributeProcessor.processAttribute(attribute.getName(), 1L);
                break;
            }
            case 15: {
                String value = DebugAttributesReaderKt.access$readStringFromTable(this.reader, this.cuHeader.getWordSize(), this.debugStrOffset);
                this.attributeProcessor.processAttribute(attribute.getName(), value);
                break;
            }
            case 16: {
                long value = this.referenceBytesConverter.asLongValue(this.reader.readBytes(1)) + this.cuHeader.getOffset();
                this.attributeProcessor.processAttribute(attribute.getName(), value);
                break;
            }
            case 17: {
                long value = this.referenceBytesConverter.asLongValue(this.reader.readBytes(2)) + this.cuHeader.getOffset();
                this.attributeProcessor.processAttribute(attribute.getName(), value);
                break;
            }
            case 18: {
                long value = this.referenceBytesConverter.asLongValue(this.reader.readBytes(4)) + this.cuHeader.getOffset();
                this.attributeProcessor.processAttribute(attribute.getName(), value);
                break;
            }
            case 19: {
                long value = this.referenceBytesConverter.asLongValue(this.reader.readBytes(8)) + this.cuHeader.getOffset();
                this.attributeProcessor.processAttribute(attribute.getName(), value);
                break;
            }
            case 20: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readLong(DebugAttributesReaderKt.access$getBytesCountForRefAddr(this.cuHeader)));
                break;
            }
            case 21: {
                this.attributeProcessor.processAttribute(attribute.getName(), (long)this.reader.readULEB128() + this.cuHeader.getOffset());
                break;
            }
            case 22: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytes(8));
                break;
            }
            case 23: {
                this.attributeProcessor.processAttribute(attribute.getName(), attribute.getForm(), this.reader.readBytesWithBlockSize());
                break;
            }
            case 24: {
                this.attributeProcessor.processAttribute(attribute.getName(), this.reader.readLong(this.cuHeader.getWordSize()));
                break;
            }
            default: {
                this.attributeProcessor.processAttribute(attribute.getName(), 0L);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DWForm.values().length];
            nArray[DWForm.ADDR.ordinal()] = 1;
            nArray[DWForm.BLOCK.ordinal()] = 2;
            nArray[DWForm.BLOCK1.ordinal()] = 3;
            nArray[DWForm.BLOCK2.ordinal()] = 4;
            nArray[DWForm.BLOCK4.ordinal()] = 5;
            nArray[DWForm.DATA1.ordinal()] = 6;
            nArray[DWForm.DATA2.ordinal()] = 7;
            nArray[DWForm.DATA4.ordinal()] = 8;
            nArray[DWForm.DATA8.ordinal()] = 9;
            nArray[DWForm.SDATA.ordinal()] = 10;
            nArray[DWForm.UDATA.ordinal()] = 11;
            nArray[DWForm.STRING.ordinal()] = 12;
            nArray[DWForm.FLAG.ordinal()] = 13;
            nArray[DWForm.FLAG_PRESENT.ordinal()] = 14;
            nArray[DWForm.STRP.ordinal()] = 15;
            nArray[DWForm.REF1.ordinal()] = 16;
            nArray[DWForm.REF2.ordinal()] = 17;
            nArray[DWForm.REF4.ordinal()] = 18;
            nArray[DWForm.REF8.ordinal()] = 19;
            nArray[DWForm.REF_ADDR.ordinal()] = 20;
            nArray[DWForm.REF_UDATA.ordinal()] = 21;
            nArray[DWForm.REF_SIG8.ordinal()] = 22;
            nArray[DWForm.EXPRLOC.ordinal()] = 23;
            nArray[DWForm.SEC_OFFSET.ordinal()] = 24;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

