/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.dwarf.info.range;

import io.appmetrica.analytics.gradle.common.Log;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.SymbolNameProvider;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.info.range.NamedRange;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/range/NamedRangesResolver;", "", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "addressSize", "", "rangesSectionOffset", "", "(Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;IJ)V", "resolveNamedRanges", "", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/info/range/NamedRange;", "offset", "nameProvider", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/SymbolNameProvider;", "baseAddress", "common"})
public final class NamedRangesResolver {
    @NotNull
    private final ByteReader reader;
    private final int addressSize;
    private final long rangesSectionOffset;

    public NamedRangesResolver(@NotNull ByteReader reader, int addressSize, long rangesSectionOffset) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
        this.addressSize = addressSize;
        this.rangesSectionOffset = rangesSectionOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<NamedRange> resolveNamedRanges(long offset, @NotNull SymbolNameProvider nameProvider, long baseAddress) {
        Intrinsics.checkNotNullParameter((Object)nameProvider, (String)"nameProvider");
        long originalOffset = this.reader.getCurrentOffset();
        try {
            List namedRanges = new ArrayList();
            this.reader.seek(this.rangesSectionOffset + offset);
            long currentBaseAddress = baseAddress;
            while (true) {
                long beginAddress = this.reader.readLong(this.addressSize);
                long endAddress = this.reader.readLong(this.addressSize);
                if (beginAddress == 0L && endAddress == 0L) break;
                if (beginAddress == -1L) {
                    currentBaseAddress = endAddress;
                    continue;
                }
                namedRanges.add(new NamedRange(nameProvider, beginAddress += currentBaseAddress, endAddress += currentBaseAddress));
            }
            List list = namedRanges;
            return list;
        }
        catch (IOException e) {
            Log.INSTANCE.debug("Could not properly resolve range entries " + e);
        }
        finally {
            this.reader.seek(originalOffset);
        }
        return CollectionsKt.emptyList();
    }
}

