/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.dwarf.line.opcode;

import io.appmetrica.analytics.gradle.common.ndk.dwarf.DwarfException;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineContext;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.DebugLineRegisters;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.opcode.ExtendedOpcodeKt;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.opcode.SpecialOpcodeKt;
import io.appmetrica.analytics.gradle.common.ndk.dwarf.line.opcode.StandardOpcodeKt;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"EXTENDED_OPCODE", "", "incrementAddressAndOpIndex", "", "context", "Lio/appmetrica/analytics/gradle/common/ndk/dwarf/line/DebugLineContext;", "operationAdvance", "processOpcode", "", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "common"})
public final class OpcodeProcessorKt {
    private static final int EXTENDED_OPCODE = 0;

    public static final boolean processOpcode(@NotNull ByteReader reader, @NotNull DebugLineContext context) throws IOException, DwarfException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int opcode = reader.readInt(1);
        if (opcode < 0) {
            throw new DwarfException("Could not process opcode " + opcode);
        }
        if (opcode >= context.getHeader().getOpcodeBase()) {
            bl = SpecialOpcodeKt.processSpecialOpcode(context, opcode);
        } else if (opcode == 0) {
            int length = reader.readULEB128();
            int exOpcode = reader.readInt(1);
            bl = ExtendedOpcodeKt.processExtendedOpcode(reader, context, exOpcode);
        } else {
            bl = StandardOpcodeKt.processStandardOpcode(reader, context, opcode);
        }
        return bl;
    }

    public static final void incrementAddressAndOpIndex(@NotNull DebugLineContext context, int operationAdvance) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DebugLineRegisters debugLineRegisters = context.getRegisters();
        debugLineRegisters.setAddress(debugLineRegisters.getAddress() + (long)(context.getHeader().getMinInstructionLength() * ((context.getRegisters().getOpIndex() + operationAdvance) / context.getHeader().getMaxOperationsPerInstruction())));
        context.getRegisters().setOpIndex((context.getRegisters().getOpIndex() + operationAdvance) % context.getHeader().getMaxOperationsPerInstruction());
    }
}

