/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.elf;

import io.appmetrica.analytics.gradle.common.ndk.elf.ElfClass;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfData;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfException;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfFileIdent;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"EI_ABIVERSION", "", "EI_CLASS", "EI_DATA", "EI_NIDENT", "EI_OSABI", "EI_VERSION", "magicNumber", "", "readElfFileIdent", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfFileIdent;", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "common"})
public final class ElfFileIdentKt {
    private static final int EI_NIDENT = 16;
    @NotNull
    private static final byte[] magicNumber;
    private static final int EI_CLASS = 4;
    private static final int EI_DATA = 5;
    private static final int EI_VERSION = 6;
    private static final int EI_OSABI = 7;
    private static final int EI_ABIVERSION = 8;

    @NotNull
    public static final ElfFileIdent readElfFileIdent(@NotNull ByteReader $this$readElfFileIdent) throws IOException, ElfException {
        Intrinsics.checkNotNullParameter((Object)$this$readElfFileIdent, (String)"<this>");
        byte[] ident = $this$readElfFileIdent.readBytes(16);
        boolean bl = false;
        byte[] byArray = Arrays.copyOf(ident, magicNumber.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
        if (!Arrays.equals(magicNumber, byArray)) {
            throw new ElfException("Invalid magic number for file");
        }
        byte version = ident[6];
        if (version != 1) {
            throw new ElfException("Invalid ELF version: " + version);
        }
        return new ElfFileIdent(ElfClass.Companion.fromValue(ident[4]), ElfData.Companion.fromValue(ident[5]), ident[6], ident[7], ident[8]);
    }

    static {
        String string = "\u007fELF";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        magicNumber = byArray;
    }
}

