/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.elf;

import io.appmetrica.analytics.gradle.common.ndk.elf.ElfFileHeader;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeader;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeaderKt;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeaders;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"ELF_SECTION_DEBUG_ABBREV", "", "ELF_SECTION_DEBUG_INFO", "ELF_SECTION_DEBUG_LINE", "ELF_SECTION_DEBUG_RANGES", "ELF_SECTION_DEBUG_STR", "ELF_SECTION_NOTE_GNU_BUILD_ID", "parseElfSectionHeaders", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSectionHeaders;", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "elfFileHeader", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfFileHeader;", "common"})
public final class ElfSectionHeadersKt {
    @NotNull
    public static final String ELF_SECTION_DEBUG_INFO = ".debug_info";
    @NotNull
    public static final String ELF_SECTION_DEBUG_ABBREV = ".debug_abbrev";
    @NotNull
    public static final String ELF_SECTION_DEBUG_STR = ".debug_str";
    @NotNull
    public static final String ELF_SECTION_DEBUG_RANGES = ".debug_ranges";
    @NotNull
    public static final String ELF_SECTION_DEBUG_LINE = ".debug_line";
    @NotNull
    public static final String ELF_SECTION_NOTE_GNU_BUILD_ID = ".note.gnu.build-id";

    @NotNull
    public static final ElfSectionHeaders parseElfSectionHeaders(@NotNull ByteReader reader, @NotNull ElfFileHeader elfFileHeader) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)elfFileHeader, (String)"elfFileHeader");
        reader.seek(elfFileHeader.getSectionHeaderOffset());
        int n = elfFileHeader.getSectionHeaderNum();
        ArrayList<ElfSectionHeader> arrayList = new ArrayList<ElfSectionHeader>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<ElfSectionHeader> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(ElfSectionHeaderKt.readElfSectionHeader(reader, elfFileHeader.getIdent().getElfClass()));
        }
        List sectionHeaders = arrayList;
        ElfSectionHeader namesSection = (ElfSectionHeader)sectionHeaders.get(elfFileHeader.getSectionHeaderStringIndex());
        ElfSectionHeaderKt.readNames(sectionHeaders, reader, namesSection.getOffset());
        return new ElfSectionHeaders(sectionHeaders);
    }
}

