/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.elf;

import io.appmetrica.analytics.gradle.common.ndk.elf.ElfMachine;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\t\u0010$\u001a\u00020\bH\u00c6\u0003J\t\u0010%\u001a\u00020\u000bH\u00c6\u0003JE\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010.\u001a\u00020(J\u0006\u0010/\u001a\u00020(J\u0006\u00100\u001a\u00020(J\t\u00101\u001a\u00020\u0016H\u00d6\u0001R\u001e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010\u00a8\u00062"}, d2={"Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSymbol;", "", "name", "", "value", "", "size", "info", "", "other", "sectionTableIndex", "", "(IJJBBS)V", "<set-?>", "fixedValue", "getFixedValue", "()J", "getInfo", "()B", "getName", "()I", "nameString", "", "getNameString", "()Ljava/lang/String;", "setNameString", "(Ljava/lang/String;)V", "getOther", "getSectionTableIndex", "()S", "getSize", "getValue", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "fixValue", "", "machine", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfMachine;", "hashCode", "isAbs", "isFunctionEntry", "isUndef", "toString", "common"})
public final class ElfSymbol {
    private final int name;
    private final long value;
    private final long size;
    private final byte info;
    private final byte other;
    private final short sectionTableIndex;
    public String nameString;
    private long fixedValue;

    public ElfSymbol(int name2, long value, long size, byte info, byte other, short sectionTableIndex) {
        this.name = name2;
        this.value = value;
        this.size = size;
        this.info = info;
        this.other = other;
        this.sectionTableIndex = sectionTableIndex;
        this.fixedValue = -1L;
    }

    public final int getName() {
        return this.name;
    }

    public final long getValue() {
        return this.value;
    }

    public final long getSize() {
        return this.size;
    }

    public final byte getInfo() {
        return this.info;
    }

    public final byte getOther() {
        return this.other;
    }

    public final short getSectionTableIndex() {
        return this.sectionTableIndex;
    }

    @NotNull
    public final String getNameString() {
        String string = this.nameString;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"nameString");
        return null;
    }

    public final void setNameString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.nameString = string;
    }

    public final long getFixedValue() {
        return this.fixedValue;
    }

    public final boolean isFunctionEntry() {
        return (byte)(this.info & 0xF) == 2;
    }

    public final boolean isUndef() {
        return this.sectionTableIndex == 0;
    }

    public final boolean isAbs() {
        return this.sectionTableIndex == -15;
    }

    public final void fixValue(@NotNull ElfMachine machine) {
        long l;
        Intrinsics.checkNotNullParameter((Object)((Object)machine), (String)"machine");
        if (this.isAbs()) {
            l = this.value;
        } else {
            ElfMachine[] elfMachineArray = new ElfMachine[]{ElfMachine.EM_ARM, ElfMachine.EM_MIPS};
            l = CollectionsKt.listOf((Object[])elfMachineArray).contains((Object)machine) && this.isFunctionEntry() ? this.value & 0xFFFFFFFFFFFFFFFEL : this.value;
        }
        this.fixedValue = l;
    }

    public final int component1() {
        return this.name;
    }

    public final long component2() {
        return this.value;
    }

    public final long component3() {
        return this.size;
    }

    public final byte component4() {
        return this.info;
    }

    public final byte component5() {
        return this.other;
    }

    public final short component6() {
        return this.sectionTableIndex;
    }

    @NotNull
    public final ElfSymbol copy(int name2, long value, long size, byte info, byte other, short sectionTableIndex) {
        return new ElfSymbol(name2, value, size, info, other, sectionTableIndex);
    }

    public static /* synthetic */ ElfSymbol copy$default(ElfSymbol elfSymbol, int n, long l, long l2, byte by, byte by2, short s, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = elfSymbol.name;
        }
        if ((n2 & 2) != 0) {
            l = elfSymbol.value;
        }
        if ((n2 & 4) != 0) {
            l2 = elfSymbol.size;
        }
        if ((n2 & 8) != 0) {
            by = elfSymbol.info;
        }
        if ((n2 & 0x10) != 0) {
            by2 = elfSymbol.other;
        }
        if ((n2 & 0x20) != 0) {
            s = elfSymbol.sectionTableIndex;
        }
        return elfSymbol.copy(n, l, l2, by, by2, s);
    }

    @NotNull
    public String toString() {
        return "ElfSymbol(name=" + this.name + ", value=" + this.value + ", size=" + this.size + ", info=" + this.info + ", other=" + this.other + ", sectionTableIndex=" + this.sectionTableIndex + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.name);
        result = result * 31 + Long.hashCode(this.value);
        result = result * 31 + Long.hashCode(this.size);
        result = result * 31 + Byte.hashCode(this.info);
        result = result * 31 + Byte.hashCode(this.other);
        result = result * 31 + Short.hashCode(this.sectionTableIndex);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ElfSymbol)) {
            return false;
        }
        ElfSymbol elfSymbol = (ElfSymbol)other;
        if (this.name != elfSymbol.name) {
            return false;
        }
        if (this.value != elfSymbol.value) {
            return false;
        }
        if (this.size != elfSymbol.size) {
            return false;
        }
        if (this.info != elfSymbol.info) {
            return false;
        }
        if (this.other != elfSymbol.other) {
            return false;
        }
        return this.sectionTableIndex == elfSymbol.sectionTableIndex;
    }
}

