/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.elf;

import io.appmetrica.analytics.gradle.common.ndk.elf.ElfClass;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfFileHeader;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeader;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeaders;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSymbol;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSymbolKt;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\u001a.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u001a$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0014\u0010 \u001a\u00020\u0016*\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0002\u001a\"\u0010#\u001a\u00020$*\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"SHN_ABS", "", "SHN_UNDEF", "STB_GLOBAL", "", "STB_HIOS", "STB_HIPROC", "STB_LOCAL", "STB_LOOS", "STB_LOPROC", "STB_WEAK", "STT_FILE", "STT_FUNC", "STT_HIOS", "STT_HIPROC", "STT_LOOS", "STT_LOPROC", "STT_NOTYPE", "STT_OBJECT", "STT_SECTION", "parseElfSymbols", "", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSymbol;", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "elfFileHeader", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfFileHeader;", "symTabSection", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSectionHeader;", "namesSection", "sectionHeaders", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSectionHeaders;", "readElfSymbol", "elfClass", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfClass;", "readNames", "", "namesSectionOffset", "", "common"})
public final class ElfSymbolKt {
    private static final int STB_LOCAL = 0;
    private static final int STB_GLOBAL = 1;
    private static final int STB_WEAK = 2;
    private static final int STB_LOOS = 10;
    private static final int STB_HIOS = 12;
    private static final int STB_LOPROC = 13;
    private static final int STB_HIPROC = 15;
    private static final int STT_NOTYPE = 0;
    private static final int STT_OBJECT = 1;
    private static final int STT_FUNC = 2;
    private static final int STT_SECTION = 3;
    private static final int STT_FILE = 4;
    private static final int STT_LOOS = 10;
    private static final int STT_HIOS = 12;
    private static final int STT_LOPROC = 13;
    private static final int STT_HIPROC = 15;
    private static final short SHN_UNDEF = 0;
    private static final short SHN_ABS = -15;

    @NotNull
    public static final List<ElfSymbol> parseElfSymbols(@NotNull ByteReader reader, @NotNull ElfFileHeader elfFileHeader, @NotNull ElfSectionHeaders sectionHeaders) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)elfFileHeader, (String)"elfFileHeader");
        Intrinsics.checkNotNullParameter((Object)sectionHeaders, (String)"sectionHeaders");
        List symbols = new ArrayList();
        Iterable $this$forEach$iv = sectionHeaders.findHeaders((Function1<? super ElfSectionHeader, Boolean>)((Function1)parseElfSymbols.1.INSTANCE));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ElfSectionHeader namesSection;
            ElfSectionHeader symTabSection = (ElfSectionHeader)element$iv;
            boolean bl = false;
            if (sectionHeaders.getHeaderByIndex(symTabSection.getLink()) == null) continue;
            boolean bl2 = false;
            symbols.addAll((Collection)ElfSymbolKt.parseElfSymbols(reader, elfFileHeader, symTabSection, namesSection));
        }
        return symbols;
    }

    private static final List<ElfSymbol> parseElfSymbols(ByteReader reader, ElfFileHeader elfFileHeader, ElfSectionHeader symTabSection, ElfSectionHeader namesSection) throws IOException {
        reader.seek(symTabSection.getOffset());
        int numSymbols = (int)(symTabSection.getSize() / symTabSection.getEntrySize());
        ArrayList<ElfSymbol> arrayList = new ArrayList<ElfSymbol>(numSymbols);
        int n = 0;
        while (n < numSymbols) {
            ElfSymbol elfSymbol;
            int n2;
            int n3 = n2 = n++;
            ArrayList<ElfSymbol> arrayList2 = arrayList;
            boolean bl = false;
            ElfSymbol $this$parseElfSymbols_u24lambda_u2d3_u24lambda_u2d2 = elfSymbol = ElfSymbolKt.readElfSymbol(reader, elfFileHeader.getIdent().getElfClass());
            boolean bl2 = false;
            $this$parseElfSymbols_u24lambda_u2d3_u24lambda_u2d2.fixValue(elfFileHeader.getMachine());
            arrayList2.add(elfSymbol);
        }
        List symbols = arrayList;
        ElfSymbolKt.readNames(symbols, reader, namesSection.getOffset());
        return symbols;
    }

    private static final ElfSymbol readElfSymbol(ByteReader $this$readElfSymbol, ElfClass elfClass) throws IOException {
        ElfSymbol elfSymbol;
        switch (WhenMappings.$EnumSwitchMapping$0[elfClass.ordinal()]) {
            case 1: {
                int name2 = ByteReader.readInt$default($this$readElfSymbol, 0, 1, null);
                long value = $this$readElfSymbol.readLong(elfClass.getWordSize());
                long size = $this$readElfSymbol.readLong(elfClass.getWordSize());
                byte info = $this$readElfSymbol.readByte();
                byte other = $this$readElfSymbol.readByte();
                short sectionTableIndex = ByteReader.readShort$default($this$readElfSymbol, 0, 1, null);
                elfSymbol = new ElfSymbol(name2, value, size, info, other, sectionTableIndex);
                break;
            }
            case 2: {
                int name3 = ByteReader.readInt$default($this$readElfSymbol, 0, 1, null);
                byte info = $this$readElfSymbol.readByte();
                byte other = $this$readElfSymbol.readByte();
                short sectionTableIndex = ByteReader.readShort$default($this$readElfSymbol, 0, 1, null);
                long value = $this$readElfSymbol.readLong(elfClass.getWordSize());
                long size = $this$readElfSymbol.readLong(elfClass.getWordSize());
                elfSymbol = new ElfSymbol(name3, value, size, info, other, sectionTableIndex);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return elfSymbol;
    }

    /*
     * WARNING - void declaration
     */
    private static final void readNames(List<ElfSymbol> $this$readNames, ByteReader reader, long namesSectionOffset) throws IOException {
        void $this$forEach$iv;
        Iterable $this$sortedBy$iv = $this$readNames;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ElfSymbol it = (ElfSymbol)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getName());
                it = (ElfSymbol)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getName()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ElfSymbol symbol = (ElfSymbol)element$iv;
            boolean bl = false;
            reader.seek(namesSectionOffset + (long)symbol.getName());
            symbol.setNameString(reader.readNullTerminatedString(Charsets.UTF_8));
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ElfClass.values().length];
            nArray[ElfClass.ELF_CLASS_32.ordinal()] = 1;
            nArray[ElfClass.ELF_CLASS_64.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

