/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.ndk.elf;

import io.appmetrica.analytics.gradle.common.ndk.elf.ElfNote;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfNoteKt;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfProgramHeader;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfProgramHeaders;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeader;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfSectionHeaders;
import io.appmetrica.analytics.gradle.common.ndk.elf.ElfUuidKt;
import io.appmetrica.analytics.gradle.common.ndk.io.ByteReader;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e\u001a\"\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\b\u0012\u0004\u0012\u00020\u00130\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"GNU_BUILD_ID_SIZE", "", "MAX_PAGE_SIZE", "", "NT_GNU_BUILD_ID", "hashElfTextSection", "", "reader", "Lio/appmetrica/analytics/gradle/common/ndk/io/ByteReader;", "headers", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfSectionHeaders;", "parseElfBuildId", "sectionHeaders", "programHeaders", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfProgramHeaders;", "parseElfBuildIdNote", "parseElfBuildIdNoteFromProgramHeader", "parseElfBuildIdNoteFromSectionHeader", "findNtGnuBuildId", "Lio/appmetrica/analytics/gradle/common/ndk/elf/ElfNote;", "", "common"})
public final class ElfUuidKt {
    private static final int GNU_BUILD_ID_SIZE = 16;
    private static final int NT_GNU_BUILD_ID = 3;
    private static final long MAX_PAGE_SIZE = 4096L;

    @Nullable
    public static final byte[] parseElfBuildId(@NotNull ByteReader reader, @NotNull ElfSectionHeaders sectionHeaders, @NotNull ElfProgramHeaders programHeaders) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)sectionHeaders, (String)"sectionHeaders");
        Intrinsics.checkNotNullParameter((Object)programHeaders, (String)"programHeaders");
        byte[] byArray = ElfUuidKt.parseElfBuildIdNote(reader, sectionHeaders, programHeaders);
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            return it;
        }
        return ElfUuidKt.hashElfTextSection(reader, sectionHeaders);
    }

    private static final byte[] parseElfBuildIdNote(ByteReader reader, ElfSectionHeaders sectionHeaders, ElfProgramHeaders programHeaders) throws IOException {
        byte[] byArray = ElfUuidKt.parseElfBuildIdNoteFromProgramHeader(reader, programHeaders);
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            return it;
        }
        return ElfUuidKt.parseElfBuildIdNoteFromSectionHeader(reader, sectionHeaders);
    }

    private static final byte[] parseElfBuildIdNoteFromProgramHeader(ByteReader reader, ElfProgramHeaders headers) throws IOException {
        Iterable $this$forEach$iv = headers.findHeaders((Function1<? super ElfProgramHeader, Boolean>)((Function1)parseElfBuildIdNoteFromProgramHeader.1.INSTANCE));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ElfProgramHeader header = (ElfProgramHeader)element$iv;
            boolean bl = false;
            ElfNote elfNote = ElfUuidKt.findNtGnuBuildId(ElfNoteKt.parseElfNotes(reader, header));
            if (elfNote == null) continue;
            ElfNote it = elfNote;
            boolean bl2 = false;
            return it.getDesc();
        }
        return null;
    }

    private static final byte[] parseElfBuildIdNoteFromSectionHeader(ByteReader reader, ElfSectionHeaders headers) throws IOException {
        Object object;
        ElfSectionHeader elfSectionHeader = headers.findHeader((Function1<? super ElfSectionHeader, Boolean>)((Function1)parseElfBuildIdNoteFromSectionHeader.1.INSTANCE));
        if (elfSectionHeader != null) {
            ElfSectionHeader it = elfSectionHeader;
            boolean bl = false;
            ElfNote elfNote = ElfUuidKt.findNtGnuBuildId(ElfNoteKt.parseElfNotes(reader, it));
            object = elfNote != null ? elfNote.getDesc() : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final byte[] hashElfTextSection(ByteReader reader, ElfSectionHeaders headers) throws IOException {
        byte[] byArray;
        ElfSectionHeader elfSectionHeader = headers.findHeader((Function1<? super ElfSectionHeader, Boolean>)((Function1)hashElfTextSection.1.INSTANCE));
        if (elfSectionHeader != null) {
            byte[] byArray2;
            ElfSectionHeader it = elfSectionHeader;
            boolean bl = false;
            byte[] buildId = new byte[16];
            long oldOffset = reader.getCurrentOffset();
            long endOffset = it.getOffset() + Math.min(it.getSize(), 4096L);
            reader.seek(it.getOffset());
            while (reader.getCurrentOffset() < endOffset) {
                int n = buildId.length;
                for (int i = 0; i < n; ++i) {
                    buildId[i] = (byte)(buildId[i] ^ reader.readByte());
                }
            }
            byte[] it2 = byArray2 = buildId;
            boolean bl2 = false;
            reader.seek(oldOffset);
            byArray = byArray2;
        } else {
            byArray = null;
        }
        return byArray;
    }

    private static final ElfNote findNtGnuBuildId(List<ElfNote> $this$findNtGnuBuildId) {
        Object v0;
        block1: {
            Iterable iterable = $this$findNtGnuBuildId;
            for (Object t : iterable) {
                ElfNote it = (ElfNote)t;
                boolean bl = false;
                if (!(it.getType() == 3)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

