/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.provider;

import com.google.gson.Gson;
import io.appmetrica.analytics.gradle.common.BuildInfo;
import io.appmetrica.analytics.gradle.common.MappingType;
import io.appmetrica.analytics.gradle.common.api.AndroidApplicationVariant;
import io.appmetrica.analytics.gradle.common.provider.FileInfo;
import io.appmetrica.analytics.gradle.common.provider.FileProvider;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/appmetrica/analytics/gradle/common/provider/BuildInfoFileProvider;", "Lio/appmetrica/analytics/gradle/common/provider/FileProvider;", "project", "Lorg/gradle/api/Project;", "buildId", "", "variant", "Lio/appmetrica/analytics/gradle/common/api/AndroidApplicationVariant;", "(Lorg/gradle/api/Project;Ljava/lang/String;Lio/appmetrica/analytics/gradle/common/api/AndroidApplicationVariant;)V", "mappingType", "Lio/appmetrica/analytics/gradle/common/MappingType;", "splitVersionCodes", "", "", "versionCode", "versionName", "getBuildInfo", "Lio/appmetrica/analytics/gradle/common/BuildInfo;", "getUploadFiles", "", "Lio/appmetrica/analytics/gradle/common/provider/FileInfo;", "common"})
public final class BuildInfoFileProvider
implements FileProvider {
    @NotNull
    private final String buildId;
    @NotNull
    private final String versionName;
    private final int versionCode;
    @NotNull
    private final Set<Integer> splitVersionCodes;
    @NotNull
    private final MappingType mappingType;

    public BuildInfoFileProvider(@NotNull Project project, @NotNull String buildId, @NotNull AndroidApplicationVariant variant) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.buildId = buildId;
        this.versionName = variant.getVersionName();
        this.versionCode = variant.getVersionCode();
        this.splitVersionCodes = variant.getSplitVersionCodes();
        Object object = project.getProperties().get("android.enableR8");
        if (object == null) {
            object = "false";
        }
        this.mappingType = Boolean.parseBoolean((String)object) ? MappingType.R8 : MappingType.PROGUARD;
    }

    @Override
    @NotNull
    public List<FileInfo> getUploadFiles() {
        File infoFile = File.createTempFile("info", ".txt");
        Intrinsics.checkNotNullExpressionValue((Object)infoFile, (String)"infoFile");
        String string = new Gson().toJson((Object)this.getBuildInfo());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Gson().toJson(getBuildInfo())");
        FilesKt.writeText$default((File)infoFile, (String)string, null, (int)2, null);
        return CollectionsKt.listOf((Object)new FileInfo("info.txt", infoFile));
    }

    private final BuildInfo getBuildInfo() {
        return new BuildInfo(this.buildId, this.versionName, this.versionCode, this.mappingType, this.splitVersionCodes);
    }
}

