/*
 * Decompiled with CFR 0.152.
 */
package io.appmetrica.analytics.gradle.common.provider;

import io.appmetrica.analytics.gradle.common.Log;
import io.appmetrica.analytics.gradle.common.config.AppMetricaPluginNdkConfig;
import io.appmetrica.analytics.gradle.common.ndk.ElfYSymFactory;
import io.appmetrica.analytics.gradle.common.ndk.YSym;
import io.appmetrica.analytics.gradle.common.ndk.YSymSerializer;
import io.appmetrica.analytics.gradle.common.provider.FileInfo;
import io.appmetrica.analytics.gradle.common.provider.FileProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006H\u0016R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0013"}, d2={"Lio/appmetrica/analytics/gradle/common/provider/SymbolsFileProvider;", "Lio/appmetrica/analytics/gradle/common/provider/FileProvider;", "ndkConfig", "Lio/appmetrica/analytics/gradle/common/config/AppMetricaPluginNdkConfig;", "(Lio/appmetrica/analytics/gradle/common/config/AppMetricaPluginNdkConfig;)V", "additionalSoFiles", "", "Ljava/io/File;", "getAdditionalSoFiles", "()Ljava/util/List;", "additionalSoFiles$delegate", "Lkotlin/Lazy;", "soFiles", "getSoFiles", "soFiles$delegate", "getFileInfo", "Lio/appmetrica/analytics/gradle/common/provider/FileInfo;", "file", "getUploadFiles", "common"})
public final class SymbolsFileProvider
implements FileProvider {
    @NotNull
    private final Lazy soFiles$delegate;
    @NotNull
    private final Lazy additionalSoFiles$delegate;

    public SymbolsFileProvider(@NotNull AppMetricaPluginNdkConfig ndkConfig) {
        Intrinsics.checkNotNullParameter((Object)ndkConfig, (String)"ndkConfig");
        this.soFiles$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends File>>(ndkConfig){
            final /* synthetic */ AppMetricaPluginNdkConfig $ndkConfig;
            {
                this.$ndkConfig = $ndkConfig;
                super(0);
            }

            @NotNull
            public final List<File> invoke() {
                return (List)this.$ndkConfig.getSoFiles().invoke();
            }
        }));
        this.additionalSoFiles$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends File>>(ndkConfig){
            final /* synthetic */ AppMetricaPluginNdkConfig $ndkConfig;
            {
                this.$ndkConfig = $ndkConfig;
                super(0);
            }

            @NotNull
            public final List<File> invoke() {
                return (List)this.$ndkConfig.getAdditionalSoFiles().invoke();
            }
        }));
    }

    private final List<File> getSoFiles() {
        Lazy lazy = this.soFiles$delegate;
        return (List)lazy.getValue();
    }

    private final List<File> getAdditionalSoFiles() {
        Lazy lazy = this.additionalSoFiles$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public List<FileInfo> getUploadFiles() {
        File it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSoFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getFileInfo(it));
        }
        $this$map$iv = this.getAdditionalSoFiles();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.getFileInfo(it));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private final FileInfo getFileInfo(File file) {
        Log.INSTANCE.info("Taking symbols from " + file.getAbsolutePath());
        File symFile = File.createTempFile(file.getName(), ".ysym");
        YSym symbols = new ElfYSymFactory().createCSymFromFile(file);
        Log.INSTANCE.info("\tUUID = " + symbols.getIdentifier());
        Intrinsics.checkNotNullExpressionValue((Object)symFile, (String)"symFile");
        FilesKt.writeText$default((File)symFile, (String)YSymSerializer.INSTANCE.toString(symbols), null, (int)2, null);
        String string = symFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"symFile.name");
        return new FileInfo(string, symFile);
    }
}

